/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterDefinition;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineSCM;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearToolUcmBaseline;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.ucm.UcmMakeBaseline;
import hudson.plugins.clearcase.ucm.UcmMakeBaselineComposite;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineParameterValue
extends ParameterValue {
    @Exported(visibility=3)
    private String baseline;
    @Exported(visibility=3)
    private String component;
    @Exported(visibility=3)
    private boolean forceRmview;
    @Exported(visibility=3)
    private String promotionLevel;
    @Exported(visibility=3)
    private String pvob;
    private List<String> restrictions;
    @Exported(visibility=3)
    private boolean snapshotView;
    @Exported(visibility=3)
    private String stream;
    @Exported(visibility=3)
    private boolean useUpdate;
    @Exported(visibility=3)
    private String viewName;
    private StringBuffer fatalErrorMessage = new StringBuffer();

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterValue(String name, String baseline, boolean forceRmview) {
        this(name, null, null, null, null, null, baseline, false, forceRmview, false);
    }

    public ClearCaseUcmBaselineParameterValue(String name, String pvob, String component, String promotionLevel, String stream, String viewName, String baseline, boolean useUpdate, boolean forceRmview, boolean snapshotView) {
        super(name);
        this.pvob = ClearCaseUcmBaselineUtils.prefixWithSeparator(pvob);
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.stream = stream;
        this.viewName = viewName;
        this.baseline = baseline;
        this.useUpdate = useUpdate;
        this.forceRmview = forceRmview;
        this.snapshotView = snapshotView;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (this.baseline == null || this.baseline.length() == 0) {
            this.fatalErrorMessage.append("The value '" + this.baseline + "' is not a valid ClearCase UCM baseline.");
        }
        DescribableList publishersList = build.getProject().getPublishersList();
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof UcmMakeBaseline) && !(publisher instanceof UcmMakeBaselineComposite)) continue;
            if (this.fatalErrorMessage.length() > 0) {
                this.fatalErrorMessage.append('\n');
            }
            this.fatalErrorMessage.append("This job is set up to use a '").append(publisher.getDescriptor().getDisplayName()).append("' publisher which is not compatible with the ClearCase UCM baseline SCM mode. Please remove this publisher.");
        }
        if (this.fatalErrorMessage.length() > 0) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    listener.fatalError(ClearCaseUcmBaselineParameterValue.this.fatalErrorMessage.toString());
                    return null;
                }
            };
        }
        if (build.getProject().getScm() instanceof ClearCaseUcmBaselineSCM) {
            return new BuildWrapper(){

                private ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
                    return new HudsonClearToolLauncher(PluginImpl.getDescriptor().getCleartoolExe(), Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineSCM.class).getDisplayName(), listener, workspace, launcher);
                }

                private String generateNormalizedViewName(VariableResolver variableResolver, String viewName) {
                    String normalizedViewName = Util.replaceMacro((String)viewName, (VariableResolver)variableResolver);
                    normalizedViewName = normalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
                    return normalizedViewName;
                }

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    BuildVariableResolver variableResolver = null;
                    try {
                        variableResolver = new BuildVariableResolver(build, launcher);
                    }
                    catch (NoSuchMethodError nsme) {
                        try {
                            variableResolver = (VariableResolver)BuildVariableResolver.class.getConstructors()[0].newInstance(build, Computer.currentComputer());
                        }
                        catch (Exception e) {
                            listener.fatalError("No variable resolver has been instantiated: The build will surely crash, but let's make a try...");
                        }
                    }
                    ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, build.getProject().getWorkspace(), launcher);
                    ClearToolUcmBaseline cleartool = new ClearToolUcmBaseline((VariableResolver)variableResolver, clearToolLauncher);
                    ClearCaseUcmBaselineParameterValue.this.viewName = this.generateNormalizedViewName((VariableResolver)variableResolver, ClearCaseUcmBaselineParameterValue.this.viewName);
                    FilePath workspace = build.getProject().getWorkspace();
                    FilePath viewPath = workspace.child(ClearCaseUcmBaselineParameterValue.this.viewName);
                    String rootDir = cleartool.getComponentRootDir(ClearCaseUcmBaselineParameterValue.this.pvob, ClearCaseUcmBaselineParameterValue.this.component);
                    StringBuilder configSpec = new StringBuilder();
                    boolean lastBuildUsedSameBaseline = false;
                    if (!ClearCaseUcmBaselineParameterValue.this.forceRmview) {
                        Run latestBuild;
                        List actions;
                        ClearCaseUcmBaselineParameterValue lastCcParamValue = null;
                        List builds = build.getProject().getBuilds();
                        if (builds.size() > 1 && (actions = (latestBuild = (Run)builds.get(1)).getActions(ParametersAction.class)) != null) {
                            for (ParametersAction action : actions) {
                                List parameters = action.getParameters();
                                if (parameters != null) {
                                    for (ParameterValue parameter : parameters) {
                                        if (!(parameter instanceof ClearCaseUcmBaselineParameterValue)) continue;
                                        lastCcParamValue = (ClearCaseUcmBaselineParameterValue)parameter;
                                        break;
                                    }
                                }
                                if (lastCcParamValue == null) continue;
                                break;
                            }
                        }
                        if (lastCcParamValue != null && ClearCaseUcmBaselineParameterValue.this.pvob.equals(lastCcParamValue.pvob) && ClearCaseUcmBaselineParameterValue.this.component.equals(lastCcParamValue.component) && ClearCaseUcmBaselineParameterValue.this.baseline.equals(lastCcParamValue.baseline)) {
                            lastBuildUsedSameBaseline = true;
                        }
                    }
                    String newlineForOS = launcher.isUnix() ? "\n" : "\r\n";
                    final String fileSepForOS = PathUtil.fileSepForOS((boolean)launcher.isUnix());
                    if (ClearCaseUcmBaselineParameterValue.this.forceRmview || !lastBuildUsedSameBaseline || !viewPath.exists()) {
                        String[] dependentBaselines;
                        if (viewPath.exists()) {
                            if (!ClearCaseUcmBaselineParameterValue.this.useUpdate || ClearCaseUcmBaselineParameterValue.this.forceRmview) {
                                cleartool.rmview(ClearCaseUcmBaselineParameterValue.this.viewName);
                                cleartool.mkview(ClearCaseUcmBaselineParameterValue.this.viewName, ClearCaseUcmBaselineParameterValue.this.snapshotView, null);
                            }
                        } else {
                            cleartool.mkview(ClearCaseUcmBaselineParameterValue.this.viewName, ClearCaseUcmBaselineParameterValue.this.snapshotView, null);
                        }
                        configSpec.append("element * CHECKEDOUT").append(newlineForOS);
                        StringBuilder loadRules = new StringBuilder();
                        for (String dependentBaselineSelector : dependentBaselines = cleartool.getDependentBaselines(ClearCaseUcmBaselineParameterValue.this.pvob, ClearCaseUcmBaselineParameterValue.this.baseline)) {
                            int indexOfSeparator = dependentBaselineSelector.indexOf(64);
                            if (indexOfSeparator == -1) continue;
                            String dependentBaseline = dependentBaselineSelector.substring(0, indexOfSeparator);
                            String component = cleartool.getComponentFromBaseline(ClearCaseUcmBaselineParameterValue.this.pvob, dependentBaseline);
                            rootDir = cleartool.getComponentRootDir(ClearCaseUcmBaselineParameterValue.this.pvob, component);
                            configSpec.append("element \"").append(rootDir).append(fileSepForOS + "...\" ").append(dependentBaseline).append(" -nocheckout").append(newlineForOS);
                            if (ClearCaseUcmBaselineParameterValue.this.restrictions != null && ClearCaseUcmBaselineParameterValue.this.restrictions.size() > 0) {
                                for (String restriction : ClearCaseUcmBaselineParameterValue.this.restrictions) {
                                    if (!restriction.startsWith(rootDir)) continue;
                                    loadRules.append("load ").append(restriction).append(newlineForOS);
                                }
                                continue;
                            }
                            loadRules.append("load ").append(rootDir).append(newlineForOS);
                        }
                        configSpec.append(newlineForOS);
                        configSpec.append("element * /main/0 -ucm -nocheckout").append(newlineForOS);
                        configSpec.append(newlineForOS);
                        configSpec.append((CharSequence)loadRules).append(newlineForOS);
                        listener.getLogger().println("The view will be created based on the following config spec:");
                        listener.getLogger().println("--- config spec start ---");
                        listener.getLogger().print(configSpec.toString());
                        listener.getLogger().println("---  config spec end  ---");
                    } else {
                        listener.getLogger().println("The requested ClearCase UCM baseline is the same as previous build: Reusing previously loaded view");
                    }
                    return new BuildWrapper.Environment(){

                        public void buildEnvVars(Map<String, String> env) {
                            env.put("CLEARCASE_BASELINE", ClearCaseUcmBaselineParameterValue.this.baseline);
                            env.put("CLEARCASE_VIEWNAME", ClearCaseUcmBaselineParameterValue.this.viewName);
                            env.put("CLEARCASE_VIEWPATH", env.get("WORKSPACE") + fileSepForOS + ClearCaseUcmBaselineParameterValue.this.viewName);
                        }
                    };
                }
            };
        }
        return new BuildWrapper(){

            public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                String ccUcmBaselineSCMDisplayName = Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineSCM.class).getDisplayName();
                listener.fatalError("This job is not set up to use a '" + ccUcmBaselineSCMDisplayName + "' SCM while it has a '" + Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineParameterDefinition.class).getDisplayName() + "' parameter: Either remove the parameter or set the SCM to be '" + ccUcmBaselineSCMDisplayName + "'; In the meantime: Aborting!");
                return null;
            }
        };
    }

    public String getBaseline() {
        return this.baseline;
    }

    public void setBaseline(String baseline) {
        this.baseline = baseline;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public boolean getForceRmview() {
        return this.forceRmview;
    }

    public void setForceRmview(boolean forceRmview) {
        this.forceRmview = forceRmview;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public void setPromotionLevel(String promotionLevel) {
        this.promotionLevel = promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public void setPvob(String pvob) {
        this.pvob = pvob;
    }

    public void setRestrictions(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    public boolean getSnapshotView() {
        return this.snapshotView;
    }

    public void setSnapshotView(boolean snapshotView) {
        this.snapshotView = snapshotView;
    }

    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public boolean getUseUpdate() {
        return this.useUpdate;
    }

    public void setUseUpdate(boolean useUpdate) {
        this.useUpdate = useUpdate;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

