/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterValue;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.PluginImpl;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineParameterDefinition
extends ParameterDefinition
implements Comparable<ClearCaseUcmBaselineParameterDefinition> {
    public static final String PARAMETER_NAME = "ClearCase UCM baseline";
    private final String component;
    private final boolean excludeElementCheckedout;
    private final boolean forceRmview;
    private final String mkviewOptionalParam;
    private final String promotionLevel;
    private final String pvob;
    private final String restrictions;
    private final boolean snapshotView;
    private final String stream;
    private final boolean useUpdate;
    private final String viewName;
    private final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(ClearCaseUcmBaselineParameterDefinition.class.getName());

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterDefinition(String pvob, String component, String promotionLevel, String stream, String restrictions, String viewName, String mkviewOptionalParam, boolean snapshotView, boolean useUpdate, boolean forceRmview, boolean excludeElementCheckedout, String uuid) {
        super(PARAMETER_NAME);
        this.pvob = ClearCaseUcmBaselineUtils.prefixWithSeparator((String)pvob);
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.stream = stream;
        this.restrictions = restrictions;
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.snapshotView = snapshotView;
        this.useUpdate = useUpdate;
        this.forceRmview = forceRmview;
        this.excludeElementCheckedout = excludeElementCheckedout;
        this.uuid = uuid == null || uuid.length() == 0 ? UUID.randomUUID() : UUID.fromString(uuid);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new ClearCaseUcmBaselineParameterValue(this.getName(), this.getPvob(), this.getComponent(), this.getPromotionLevel(), this.getStream(), this.getViewName(), this.getMkviewOptionalParam(), values[0], this.getUseUpdate(), this.getForceRmview(), this.getSnapshotView(), this.getExcludeElementCheckedout());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ClearCaseUcmBaselineParameterValue value = (ClearCaseUcmBaselineParameterValue)req.bindJSON(ClearCaseUcmBaselineParameterValue.class, formData);
        value.setPvob(this.pvob);
        value.setComponent(this.component);
        value.setPromotionLevel(this.promotionLevel);
        value.setRestrictions(this.getRestrictionsAsList());
        value.setViewName(this.viewName);
        value.setMkviewOptionalParam(this.mkviewOptionalParam);
        value.setSnapshotView(this.snapshotView);
        value.setUseUpdate(this.useUpdate);
        value.setExcludeElementCheckedout(this.excludeElementCheckedout);
        return value;
    }

    public String[] getBaselines() throws IOException, InterruptedException {
        Computer computerRunnningThisJob;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(PluginImpl.getDescriptor().getCleartoolExe());
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[name]p ");
        if (StringUtils.isNotEmpty((String)this.promotionLevel)) {
            cmd.add("-level");
            cmd.add(this.promotionLevel);
        }
        if (StringUtils.isNotEmpty((String)this.stream)) {
            cmd.add("-stream");
            cmd.add(this.stream + '@' + this.pvob);
        }
        cmd.add("-component");
        cmd.add(this.component + '@' + this.pvob);
        Hudson nodeRunningThisJob = Hudson.getInstance();
        for (Node node : Hudson.getInstance().getNodes()) {
            List jobs;
            Computer computer = node.toComputer();
            if (computer == null || (jobs = computer.getTiedJobs()) == null) continue;
            boolean nodeRunningThisJobFound = false;
            for (AbstractProject project : jobs) {
                ClearCaseUcmBaselineParameterDefinition pd;
                ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
                if (property == null || (pd = (ClearCaseUcmBaselineParameterDefinition)property.getParameterDefinition(PARAMETER_NAME)) == null || pd.compareTo(this) != 0) continue;
                nodeRunningThisJob = node;
                nodeRunningThisJobFound = true;
                break;
            }
            if (!nodeRunningThisJobFound) continue;
            break;
        }
        if ((computerRunnningThisJob = nodeRunningThisJob.toComputer()).isOffline()) {
            if (computerRunnningThisJob.isLaunchSupported()) {
                LOGGER.log(Level.INFO, "{0} is offline. Trying to launch it...", nodeRunningThisJob.getDisplayName());
                try {
                    computerRunnningThisJob.connect(false).get();
                    LOGGER.log(Level.INFO, "Waiting 10 seconds for {0} to be launched...", nodeRunningThisJob.getDisplayName());
                    Thread.sleep(10000L);
                    do {
                        Thread.sleep(1000L);
                    } while (computerRunnningThisJob.isConnecting());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "An exception occurred while launching " + nodeRunningThisJob.getDisplayName(), e);
                    return null;
                }
            } else {
                LOGGER.log(Level.SEVERE, "{0} can't be automatically launched. You must start it before trying to run this job.", nodeRunningThisJob.getDisplayName());
                return null;
            }
        }
        if (computerRunnningThisJob.isOnline()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            nodeRunningThisJob.createLauncher(TaskListener.NULL).launch().cmds(cmd).stdout((OutputStream)baos).join();
            String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput((ByteArrayOutputStream)baos);
            baos.close();
            if (cleartoolOutput.toString().contains("cleartool: Error")) {
                LOGGER.log(Level.WARNING, "An error occurred while gathering ClearCase UCM baselines: {0}", cleartoolOutput);
                return null;
            }
            return cleartoolOutput.toString().split(" ");
        }
        LOGGER.log(Level.SEVERE, "{0} is offline and couldn't be launched.", nodeRunningThisJob.getDisplayName());
        return null;
    }

    public String getComponent() {
        return this.component;
    }

    public boolean getExcludeElementCheckedout() {
        return this.excludeElementCheckedout;
    }

    public boolean getForceRmview() {
        return this.forceRmview;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public String getRestrictions() {
        return this.restrictions;
    }

    public List<String> getRestrictionsAsList() {
        ArrayList<String> restrictionsAsList = new ArrayList<String>();
        if (this.getRestrictions() != null && this.getRestrictions().length() > 0) {
            for (String restriction : Util.tokenize((String)this.getRestrictions(), (String)"\n\r\f")) {
                restrictionsAsList.add(restriction);
            }
        }
        return restrictionsAsList;
    }

    public boolean getSnapshotView() {
        return this.snapshotView;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean getUseUpdate() {
        return this.useUpdate;
    }

    public String getViewName() {
        return this.viewName;
    }

    @Override
    public int compareTo(ClearCaseUcmBaselineParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }
}

