/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterDefinition;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineSCM;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineSCM
extends SCM {
    public static final String CLEARCASE_BASELINE_ENVSTR = "CLEARCASE_BASELINE";

    @DataBoundConstructor
    public ClearCaseUcmBaselineSCM() {
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        ParametersDefinitionProperty params = (ParametersDefinitionProperty)build.getProject().getProperty(ParametersDefinitionProperty.class);
        if (params == null) {
            listener.fatalError("No parameters have been defined for this project: To use the ClearCase UCM baseline mode, you MUST add a 'ClearCase UCM baseline' parameter to the project.");
            return false;
        }
        int clearCaseUcmBaselineParameters = 0;
        for (ParameterDefinition pd : params.getParameterDefinitions()) {
            if (!pd.getName().equals("ClearCase UCM baseline")) continue;
            if (!(pd instanceof ClearCaseUcmBaselineParameterDefinition)) {
                listener.fatalError("A parameter named 'ClearCase UCM baseline' doesn't correspond to what's expected by " + Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineSCM.class).getDisplayName() + " (e.g. you may have added a String parameter named '" + "ClearCase UCM baseline" + "'); Remove it from the project configuration before trying to run the build again.");
                return false;
            }
            ++clearCaseUcmBaselineParameters;
        }
        if (clearCaseUcmBaselineParameters > 1) {
            listener.fatalError("More than two 'ClearCase UCM baseline' parameters have been defined for this project: Aborting the build to avoid any conflict with the CLEARCASE_VIEWNAME and CLEARCASE_VIEWPATH environment variables; Edit the project configuration and remove one of them before trying to run the build again.");
            return false;
        }
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        return false;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> ab, Launcher lnchr, TaskListener tl) throws IOException, InterruptedException {
        return null;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> ap, Launcher lnchr, FilePath fp, TaskListener tl, SCMRevisionState scmrs) throws IOException, InterruptedException {
        return null;
    }
}

