/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseChangeLogSet;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolFactory;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    private String branch;
    private boolean useUpdate;
    private String configSpec;
    private String viewName;
    private String vobPaths;
    private boolean useDynamicView;
    private String viewDrive;
    private transient ClearToolFactory clearToolFactory;

    public ClearCaseSCM(ClearToolFactory clearToolFactory, String branch, String configSpec, String viewName, boolean useUpdate, String vobPaths, boolean useDynamicView, String viewDrive) {
        this.clearToolFactory = clearToolFactory;
        this.branch = branch;
        this.configSpec = configSpec;
        this.viewName = viewName;
        this.useUpdate = useUpdate;
        this.useDynamicView = useDynamicView;
        this.viewDrive = viewDrive;
        this.vobPaths = vobPaths;
        if (this.useDynamicView) {
            this.useUpdate = false;
        }
    }

    public ClearCaseSCM(String branch, String configSpec, String viewName, boolean useUpdate, String vobPaths, boolean useDynamicView, String viewDrive) {
        this(null, branch, configSpec, viewName, useUpdate, vobPaths, useDynamicView, viewDrive);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "hudson_view";
        }
        return this.viewName;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getVobPaths() {
        return this.vobPaths;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.DESCRIPTOR;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.viewName != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.viewName);
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        ClearTool cleartool;
        if (this.clearToolFactory == null) {
            this.clearToolFactory = new ClearToolFactoryImpl(null);
        }
        if ((cleartool = this.clearToolFactory.create(this, (TaskListener)listener)) == null) {
            return false;
        }
        cleartool.setVobPaths(this.vobPaths);
        ClearToolLauncherImpl ctLauncher = new ClearToolLauncherImpl((TaskListener)listener, workspace, launcher);
        boolean updateView = this.useUpdate;
        if (!this.useDynamicView) {
            boolean localViewPathExists = new FilePath(workspace, this.viewName).exists();
            if (localViewPathExists) {
                if (updateView) {
                    String currentConfigSpec = cleartool.catcs((ClearToolLauncher)ctLauncher, this.viewName).trim();
                    if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                        updateView = false;
                    }
                }
                if (!updateView) {
                    cleartool.rmview((ClearToolLauncher)ctLauncher, this.viewName);
                    localViewPathExists = false;
                }
            }
            if (!localViewPathExists) {
                cleartool.mkview((ClearToolLauncher)ctLauncher, this.viewName);
                cleartool.setcs((ClearToolLauncher)ctLauncher, this.viewName, this.configSpec);
                updateView = false;
            }
            if (updateView && updateView) {
                cleartool.update((ClearToolLauncher)ctLauncher, this.viewName);
            }
        } else {
            String currentConfigSpec = cleartool.catcs((ClearToolLauncher)ctLauncher, this.viewName).trim();
            if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                cleartool.setcs((ClearToolLauncher)ctLauncher, this.viewName, this.configSpec);
            }
        }
        ArrayList history = new ArrayList();
        if (build.getPreviousBuild() != null) {
            Date time = build.getPreviousBuild().getTimestamp().getTime();
            for (String branchName : this.getBranchNames(this.branch)) {
                history.addAll(cleartool.lshistory((ClearToolLauncher)ctLauncher, time, this.viewName, branchName));
            }
        }
        if (history.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(changelogFile);
        ClearCaseChangeLogSet.saveToChangeLog((OutputStream)fileOutputStream, history);
        return true;
    }

    private String[] getBranchNames(String branchString) {
        String[] branchArray = branchString.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ClearTool cleartool;
        if (this.clearToolFactory == null) {
            this.clearToolFactory = new ClearToolFactoryImpl(null);
        }
        if ((cleartool = this.clearToolFactory.create(this, listener)) == null) {
            return false;
        }
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        cleartool.setVobPaths(this.vobPaths);
        ClearToolLauncherImpl ctLauncher = new ClearToolLauncherImpl(listener, workspace, launcher);
        Date buildTime = lastBuild.getTimestamp().getTime();
        for (String branchName : this.getBranchNames(this.branch)) {
            List data = cleartool.lshistory((ClearToolLauncher)ctLauncher, buildTime, this.viewName, branchName);
            if (data.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    static /* synthetic */ boolean access$100(ClearCaseSCM x0) {
        return x0.useDynamicView;
    }

    static /* synthetic */ String access$200(ClearCaseSCM x0) {
        return x0.viewDrive;
    }
}

