/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogEntryMerger {
    private Map<String, List<ClearCaseChangeLogEntry>> userEntries = new HashMap();
    private transient int maxTimeDifference;

    public ChangeLogEntryMerger() {
        this(0);
    }

    public ChangeLogEntryMerger(int maxTimeDifferenceMillis) {
        this.maxTimeDifference = maxTimeDifferenceMillis + 1000;
    }

    public List<ClearCaseChangeLogEntry> getMergedList(List<ClearCaseChangeLogEntry> orgList) {
        for (ClearCaseChangeLogEntry entry : orgList) {
            boolean wasMerged = false;
            List entries = this.getUserEntries(entry.getUser());
            for (ClearCaseChangeLogEntry storedEntry : entries) {
                if (!this.canBeMerged(entry, storedEntry)) continue;
                storedEntry.addElements((Collection)entry.getElements());
                wasMerged = true;
                break;
            }
            if (wasMerged) continue;
            entries.add(entry);
        }
        List list = this.getList();
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        return list;
    }

    private List<ClearCaseChangeLogEntry> getList() {
        ArrayList<ClearCaseChangeLogEntry> list = new ArrayList<ClearCaseChangeLogEntry>();
        Set users = this.userEntries.keySet();
        for (String user : users) {
            List userList = (List)this.userEntries.get(user);
            for (ClearCaseChangeLogEntry entry : userList) {
                list.add(entry);
            }
        }
        return list;
    }

    private List<ClearCaseChangeLogEntry> getUserEntries(String user) {
        if (!this.userEntries.containsKey(user)) {
            this.userEntries.put(user, new ArrayList());
        }
        return (List)this.userEntries.get(user);
    }

    private boolean canBeMerged(ClearCaseChangeLogEntry entryOne, ClearCaseChangeLogEntry entryTwo) {
        if (entryOne.getComment().equals(entryTwo.getComment())) {
            long difference = Math.abs(entryOne.getDate().getTime() - entryTwo.getDate().getTime());
            return difference < (long)this.maxTimeDifference;
        }
        return false;
    }
}

