/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogEntryMerger {
    private Map<String, List<ClearCaseChangeLogEntry>> userEntries = new HashMap<String, List<ClearCaseChangeLogEntry>>();
    private transient int maxTimeDifference;

    public ChangeLogEntryMerger() {
        this(0);
    }

    public ChangeLogEntryMerger(int maxTimeDifferenceMillis) {
        this.maxTimeDifference = maxTimeDifferenceMillis + 1000;
    }

    public List<ClearCaseChangeLogEntry> getMergedList(List<ClearCaseChangeLogEntry> orgList) {
        for (ClearCaseChangeLogEntry entry : orgList) {
            boolean wasMerged = false;
            List<ClearCaseChangeLogEntry> entries = this.getUserEntries(entry.getUser());
            for (ClearCaseChangeLogEntry storedEntry : entries) {
                if (!this.canBeMerged(entry, storedEntry)) continue;
                storedEntry.addElements(entry.getElements());
                wasMerged = true;
                break;
            }
            if (wasMerged) continue;
            entries.add(entry);
        }
        List<ClearCaseChangeLogEntry> list = this.getList();
        Collections.sort(list, new Comparator<ClearCaseChangeLogEntry>(){

            @Override
            public int compare(ClearCaseChangeLogEntry o1, ClearCaseChangeLogEntry o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return list;
    }

    private List<ClearCaseChangeLogEntry> getList() {
        ArrayList<ClearCaseChangeLogEntry> list = new ArrayList<ClearCaseChangeLogEntry>();
        Set<String> users = this.userEntries.keySet();
        for (String user : users) {
            List<ClearCaseChangeLogEntry> userList = this.userEntries.get(user);
            for (ClearCaseChangeLogEntry entry : userList) {
                list.add(entry);
            }
        }
        return list;
    }

    private List<ClearCaseChangeLogEntry> getUserEntries(String user) {
        if (!this.userEntries.containsKey(user)) {
            this.userEntries.put(user, new ArrayList());
        }
        return this.userEntries.get(user);
    }

    private boolean canBeMerged(ClearCaseChangeLogEntry entryOne, ClearCaseChangeLogEntry entryTwo) {
        if (entryOne.getComment().equals(entryTwo.getComment())) {
            long difference = Math.abs(entryOne.getDate().getTime() - entryTwo.getDate().getTime());
            return difference < (long)this.maxTimeDifference;
        }
        return false;
    }
}

