/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseChangeLogSet;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolFactory;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.util.ChangeLogEntryMerger;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ByteBuffer;
import hudson.util.ForkOutputStream;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    private String branch;
    private boolean useUpdate;
    private String configSpec;
    private String viewName;
    private String vobPaths;
    private boolean useDynamicView;
    private String viewDrive;
    private String mkviewOptionalParam;
    private transient ClearToolFactory clearToolFactory;

    public ClearCaseSCM(ClearToolFactory clearToolFactory, String branch, String configSpec, String viewName, boolean useUpdate, String vobPaths, boolean useDynamicView, String viewDrive, String mkviewOptionalParam) {
        this.clearToolFactory = clearToolFactory;
        this.branch = branch;
        this.configSpec = configSpec;
        this.viewName = viewName;
        this.useUpdate = useUpdate;
        this.useDynamicView = useDynamicView;
        this.viewDrive = viewDrive;
        this.vobPaths = vobPaths;
        this.mkviewOptionalParam = mkviewOptionalParam;
        if (this.useDynamicView) {
            this.useUpdate = false;
        }
    }

    public ClearCaseSCM(String branch, String configSpec, String viewName, boolean useUpdate, String vobPaths, boolean useDynamicView, String viewDrive, String mkviewOptionalParam) {
        this(null, branch, configSpec, viewName, useUpdate, vobPaths, useDynamicView, viewDrive, mkviewOptionalParam);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "hudson_view";
        }
        return this.viewName;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getVobPaths() {
        return this.vobPaths;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.DESCRIPTOR;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.viewName != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.viewName);
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        String tempConfigSpec;
        if (this.clearToolFactory == null) {
            this.clearToolFactory = new ClearToolFactoryImpl();
        }
        ChangeLogEntryMerger merger = this.clearToolFactory.createChangeLogEntryMerger(this);
        ClearTool cleartool = this.clearToolFactory.create(this, (TaskListener)listener);
        if (cleartool == null) {
            return false;
        }
        cleartool.setVobPaths(this.vobPaths);
        ClearToolLauncherImpl ctLauncher = new ClearToolLauncherImpl((TaskListener)listener, workspace, launcher);
        boolean updateView = this.useUpdate;
        if (!this.useDynamicView) {
            boolean localViewPathExists = new FilePath(workspace, this.viewName).exists();
            if (localViewPathExists) {
                if (updateView) {
                    String currentConfigSpec = cleartool.catcs(ctLauncher, this.viewName).trim();
                    if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                        updateView = false;
                    }
                }
                if (!updateView) {
                    cleartool.rmview(ctLauncher, this.viewName);
                    localViewPathExists = false;
                }
            }
            if (!localViewPathExists) {
                cleartool.mkview(ctLauncher, this.viewName);
                tempConfigSpec = this.configSpec;
                if (launcher.isUnix()) {
                    tempConfigSpec = this.configSpec.replaceAll("\r\n", "\n");
                }
                cleartool.setcs(ctLauncher, this.viewName, tempConfigSpec);
                updateView = false;
            }
            if (updateView && updateView) {
                cleartool.update(ctLauncher, this.viewName);
            }
        } else {
            String currentConfigSpec = cleartool.catcs(ctLauncher, this.viewName).trim();
            if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                tempConfigSpec = this.configSpec;
                if (launcher.isUnix()) {
                    tempConfigSpec = this.configSpec.replaceAll("\r\n", "\n");
                }
                cleartool.setcs(ctLauncher, this.viewName, tempConfigSpec);
            }
        }
        ArrayList<ClearCaseChangeLogEntry> history = new ArrayList<ClearCaseChangeLogEntry>();
        if (build.getPreviousBuild() != null) {
            Date time = build.getPreviousBuild().getTimestamp().getTime();
            for (String branchName : this.getBranchNames(this.branch)) {
                history.addAll(cleartool.lshistory(ctLauncher, time, this.viewName, branchName));
            }
        }
        if (history.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(changelogFile);
        ClearCaseChangeLogSet.saveToChangeLog(fileOutputStream, merger.getMergedList(history));
        return true;
    }

    private String[] getBranchNames(String branchString) {
        String[] branchArray = branchString.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ClearTool cleartool;
        if (this.clearToolFactory == null) {
            this.clearToolFactory = new ClearToolFactoryImpl();
        }
        if ((cleartool = this.clearToolFactory.create(this, listener)) == null) {
            return false;
        }
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        cleartool.setVobPaths(this.vobPaths);
        ClearToolLauncherImpl ctLauncher = new ClearToolLauncherImpl(listener, workspace, launcher);
        Date buildTime = lastBuild.getTimestamp().getTime();
        for (String branchName : this.getBranchNames(this.branch)) {
            List<ClearCaseChangeLogEntry> data = cleartool.lshistory(ctLauncher, buildTime, this.viewName, branchName);
            if (data.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    private static class ClearToolFactoryImpl
    implements ClearToolFactory {
        private ClearToolFactoryImpl() {
        }

        public ClearTool create(ClearCaseSCM scm, TaskListener listener) {
            ClearToolExec clearTool = null;
            String clearToolStr = scm.getDescriptor().getCleartoolExe();
            if (clearToolStr == null || clearToolStr.length() == 0) {
                listener.fatalError("No cleartool executable is configured.");
            } else if (scm.useDynamicView) {
                clearTool = new ClearToolDynamic(clearToolStr, scm.viewDrive);
                listener.getLogger().println("Creating a dynamic cleartool");
            } else {
                clearTool = new ClearToolSnapshot(clearToolStr, scm.mkviewOptionalParam);
                listener.getLogger().println("Creating a snapshot cleartool");
            }
            return clearTool;
        }

        public ChangeLogEntryMerger createChangeLogEntryMerger(ClearCaseSCM scm) {
            return new ChangeLogEntryMerger(scm.getDescriptor().getLogMergeTimeWindow() * 1000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearCaseScmDescriptor
    extends SCMDescriptor<ClearCaseSCM>
    implements ModelObject {
        private String cleartoolExe;
        private int changeLogMergeTimeWindow = 5;

        protected ClearCaseScmDescriptor() {
            super(ClearCaseSCM.class, null);
            this.load();
        }

        public int getLogMergeTimeWindow() {
            return this.changeLogMergeTimeWindow;
        }

        public String getCleartoolExe() {
            if (this.cleartoolExe == null) {
                return "cleartool";
            }
            return this.cleartoolExe;
        }

        public String getDisplayName() {
            return "ClearCase";
        }

        public boolean configure(StaplerRequest req) {
            this.cleartoolExe = Util.fixEmpty((String)req.getParameter("clearcase.cleartoolExe").trim());
            String mergeTimeWindow = Util.fixEmpty((String)req.getParameter("clearcase.logmergetimewindow"));
            if (mergeTimeWindow != null) {
                try {
                    this.changeLogMergeTimeWindow = DecimalFormat.getIntegerInstance().parse(mergeTimeWindow).intValue();
                }
                catch (ParseException e) {
                    this.changeLogMergeTimeWindow = 5;
                }
            } else {
                this.changeLogMergeTimeWindow = 5;
            }
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            ClearCaseSCM scm = new ClearCaseSCM(req.getParameter("clearcase.branch"), req.getParameter("clearcase.configspec"), req.getParameter("clearcase.viewname"), req.getParameter("clearcase.useupdate") != null, req.getParameter("clearcase.vobpaths"), req.getParameter("clearcase.usedynamicview") != null, req.getParameter("clearcase.viewdrive"), req.getParameter("clearcase.mkviewoptionalparam"));
            return scm;
        }

        public void doCleartoolExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp).process();
        }

        public void dologMergeTimeWindowCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.error("Merge time window is mandatory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doViewNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.error("View name is mandatory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doConfigSpecCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null || v.length() == 0) {
                        this.error("Config spec is mandatory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteBuffer baos = new ByteBuffer();
            try {
                Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getCleartoolExe(), "-version"}, new String[0], (OutputStream)baos, null);
                proc.join();
                rsp.setContentType("text/plain");
                baos.writeTo((OutputStream)rsp.getOutputStream());
            }
            catch (IOException e) {
                req.setAttribute("error", (Object)e);
                rsp.forward((Object)this, "versionCheckError", req);
            }
        }
    }

    static final class ClearToolLauncherImpl
    implements ClearToolLauncher {
        private final TaskListener listener;
        private final FilePath workspace;
        private final Launcher launcher;

        public ClearToolLauncherImpl(TaskListener listener, FilePath workspace, Launcher launcher) {
            this.listener = listener;
            this.workspace = workspace;
            this.launcher = launcher;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        public FilePath getWorkspace() {
            return this.workspace;
        }

        public boolean run(String[] cmd, InputStream inputStream, OutputStream outputStream, FilePath filePath) throws IOException, InterruptedException {
            int r;
            OutputStream out = outputStream;
            FilePath path = filePath;
            String[] env = new String[]{};
            if (path == null) {
                path = this.workspace;
            }
            if ((r = this.launcher.launch(cmd, env, inputStream, out = out == null ? this.listener.getLogger() : new ForkOutputStream(out, (OutputStream)this.listener.getLogger()), path).join()) != 0) {
                StringBuilder builder = new StringBuilder();
                for (String cmdParam : cmd) {
                    if (builder.length() > 0) {
                        builder.append(" ");
                    }
                    builder.append(cmdParam);
                }
                this.listener.fatalError(PluginImpl.getDescriptor().getDisplayName() + " failed. exit code=" + r);
                throw new IOException("cleartool did not return the expected exit code. Command line=\"" + builder.toString() + "\", actual exit code=" + r);
            }
            return r == 0;
        }
    }
}

