/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;

public class SnapshotCheckoutAction
implements CheckOutAction {
    private final String viewName;
    private final String configSpec;
    private final boolean useUpdate;
    private final ClearTool cleartool;

    public SnapshotCheckoutAction(ClearTool clearTool, String viewName, String configSpec, boolean useUpdate) {
        this.cleartool = clearTool;
        this.viewName = viewName;
        this.configSpec = configSpec;
        this.useUpdate = useUpdate;
    }

    public boolean checkout(Launcher launcher, FilePath workspace) throws IOException, InterruptedException {
        boolean updateView = this.useUpdate;
        boolean localViewPathExists = new FilePath(workspace, this.viewName).exists();
        if (localViewPathExists) {
            if (updateView) {
                String currentConfigSpec = this.cleartool.catcs(this.viewName).trim();
                if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                    updateView = false;
                }
            }
            if (!updateView) {
                this.cleartool.rmview(this.viewName);
                localViewPathExists = false;
            }
        }
        if (!localViewPathExists) {
            this.cleartool.mkview(this.viewName, null);
            String tempConfigSpec = this.configSpec;
            if (launcher.isUnix()) {
                tempConfigSpec = this.configSpec.replaceAll("\r\n", "\n");
            }
            this.cleartool.setcs(this.viewName, tempConfigSpec);
            updateView = false;
        }
        if (updateView) {
            this.cleartool.update(this.viewName, null);
        }
        return true;
    }
}

