/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;

public class UcmSnapshotCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String viewName;
    private String stream;
    private String loadRules;

    public UcmSnapshotCheckoutAction(ClearTool cleartool, String viewName, String stream, String loadRules) {
        this.cleartool = cleartool;
        this.viewName = viewName;
        this.stream = stream;
        this.loadRules = loadRules;
    }

    public boolean checkout(Launcher launcher, FilePath workspace) throws IOException, InterruptedException {
        boolean localViewPathExists = new FilePath(workspace, this.viewName).exists();
        if (localViewPathExists) {
            this.cleartool.rmview(this.viewName);
            localViewPathExists = false;
        }
        this.cleartool.mkview(this.viewName, this.stream);
        for (String loadRule : Util.tokenize((String)this.loadRules, (String)"\n")) {
            this.cleartool.update(this.viewName, loadRule.trim());
        }
        return true;
    }
}

