/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String loadRules;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, String mkviewoptionalparam) {
        super(viewname, mkviewoptionalparam);
        this.stream = stream;
        this.loadRules = loadrules;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public String getStream() {
        return this.stream;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public String[] getBranchNames() {
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    public String getVobPaths() {
        StringBuilder builder = new StringBuilder();
        String[] rules = this.loadRules.split("\n");
        for (int i = 0; i < rules.length; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            String str = rules[i];
            while (str.startsWith("\\") || str.startsWith("/")) {
                str = str.substring(1);
            }
            if (str.indexOf(32) >= 0 || str.length() == 0) {
                builder.append('\"').append(str).append('\"');
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }

    protected CheckOutAction createCheckOutAction(ClearToolLauncher launcher) {
        return new UcmSnapshotCheckoutAction(this.createClearTool(launcher), this.getViewName(), this.getStream(), this.getLoadRules());
    }

    protected PollAction createPollAction(ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(launcher));
    }

    private ClearTool createClearTool(ClearToolLauncher launcher) {
        return new ClearToolSnapshot(launcher, PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getMkviewOptionalParam());
    }
}

