/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ForkOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HudsonClearToolLauncher
implements ClearToolLauncher {
    private final TaskListener listener;
    private final FilePath workspace;
    private final Launcher launcher;
    private final String scmName;

    public HudsonClearToolLauncher(String scmName, TaskListener listener, FilePath workspace, Launcher launcher) {
        this.scmName = scmName;
        this.listener = listener;
        this.workspace = workspace;
        this.launcher = launcher;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public FilePath getWorkspace() {
        return this.workspace;
    }

    public boolean run(String[] cmd, InputStream inputStream, OutputStream outputStream, FilePath filePath) throws IOException, InterruptedException {
        int r;
        OutputStream out = outputStream;
        FilePath path = filePath;
        String[] env = new String[]{};
        if (path == null) {
            path = this.workspace;
        }
        if ((r = this.launcher.launch(cmd, env, inputStream, out = out == null ? this.listener.getLogger() : new ForkOutputStream(out, (OutputStream)this.listener.getLogger()), path).join()) != 0) {
            StringBuilder builder = new StringBuilder();
            for (String cmdParam : cmd) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(cmdParam);
            }
            this.listener.fatalError(this.scmName + " failed. exit code=" + r);
            throw new IOException("cleartool did not return the expected exit code. Command line=\"" + builder.toString() + "\", actual exit code=" + r);
        }
        return true;
    }
}

