/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String loadRules;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, String mkviewoptionalparam) {
        super(viewname, mkviewoptionalparam);
        this.stream = stream;
        this.loadRules = loadrules;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public String getStream() {
        return this.stream;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public String[] getBranchNames() {
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    public String getVobPaths() {
        StringBuilder builder = new StringBuilder();
        String[] rules = this.loadRules.split("\n");
        for (int i = 0; i < rules.length; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            String str = rules[i];
            while (str.startsWith("\\") || str.startsWith("/")) {
                str = str.substring(1);
            }
            if (str.indexOf(32) >= 0 || str.length() == 0) {
                builder.append('\"').append(str).append('\"');
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }

    protected CheckOutAction createCheckOutAction(ClearToolLauncher launcher) {
        return new UcmSnapshotCheckoutAction(this.createClearTool(launcher), this.getViewName(), this.getStream(), this.getLoadRules());
    }

    protected PollAction createPollAction(ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(launcher));
    }

    private ClearTool createClearTool(ClearToolLauncher launcher) {
        return new ClearToolSnapshot(launcher, PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getMkviewOptionalParam());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearCaseUcmScmDescriptor
    extends SCMDescriptor<ClearCaseUcmSCM>
    implements ModelObject {
        protected ClearCaseUcmScmDescriptor() {
            super(ClearCaseUcmSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "UCM ClearCase";
        }

        public boolean configure(StaplerRequest req) {
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)req.bindJSON(ClearCaseUcmSCM.class, formData);
        }
    }
}

