/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ClearCaseChangeLogSet
extends ChangeLogSet<ClearCaseChangeLogEntry> {
    static final String[] TAGS = new String[]{"user", "comment", "date"};
    private List<ClearCaseChangeLogEntry> history = null;

    public ClearCaseChangeLogSet(AbstractBuild<?, ?> build, List<ClearCaseChangeLogEntry> logs) {
        super(build);
        for (ClearCaseChangeLogEntry entry : logs) {
            entry.setParent((ChangeLogSet)this);
        }
        this.history = Collections.unmodifiableList(logs);
    }

    public boolean isEmptySet() {
        return this.history.size() == 0;
    }

    public Iterator<ClearCaseChangeLogEntry> iterator() {
        return this.history.iterator();
    }

    public List<ClearCaseChangeLogEntry> getLogs() {
        return this.history;
    }

    public static ClearCaseChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        return ClearCaseChangeLogSet.parse((AbstractBuild)build, (InputStream)new FileInputStream(changeLogFile));
    }

    public static ClearCaseChangeLogSet parse(AbstractBuild build, InputStream changeLogStream) throws IOException, SAXException {
        ArrayList history = new ArrayList();
        Digester digester = new Digester();
        digester.setClassLoader(ClearCaseChangeLogSet.class.getClassLoader());
        digester.push(history);
        digester.addObjectCreate("*/entry", ClearCaseChangeLogEntry.class);
        digester.addBeanPropertySetter("*/entry/date", "dateStr");
        digester.addBeanPropertySetter("*/entry/comment");
        digester.addBeanPropertySetter("*/entry/user");
        digester.addBeanPropertySetter("*/entry/file");
        digester.addBeanPropertySetter("*/entry/action");
        digester.addBeanPropertySetter("*/entry/version");
        digester.addObjectCreate("*/entry/element", ClearCaseChangeLogEntry.FileElement.class);
        digester.addBeanPropertySetter("*/entry/element/file");
        digester.addBeanPropertySetter("*/entry/element/version");
        digester.addBeanPropertySetter("*/entry/element/action");
        digester.addBeanPropertySetter("*/entry/element/operation");
        digester.addSetNext("*/entry/element", "addElement");
        digester.addSetNext("*/entry", "add");
        digester.parse(changeLogStream);
        return new ClearCaseChangeLogSet(build, history);
    }

    public static void saveToChangeLog(OutputStream outputStream, List<ClearCaseChangeLogEntry> history) throws IOException {
        PrintStream stream = new PrintStream(outputStream, false, "UTF-8");
        int tagcount = TAGS.length;
        stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        stream.println("<history>");
        for (ClearCaseChangeLogEntry entry : history) {
            stream.println("\t<entry>");
            String[] strings = ClearCaseChangeLogSet.getEntryAsStrings((ClearCaseChangeLogEntry)entry);
            for (int tag = 0; tag < tagcount; ++tag) {
                stream.print("\t\t<");
                stream.print(TAGS[tag]);
                stream.print('>');
                stream.print(ClearCaseChangeLogSet.escapeForXml((String)strings[tag]));
                stream.print("</");
                stream.print(TAGS[tag]);
                stream.println('>');
            }
            for (ClearCaseChangeLogEntry.FileElement file : entry.getElements()) {
                stream.println("\t\t<element>");
                stream.println("\t\t\t<file>");
                stream.println(ClearCaseChangeLogSet.escapeForXml((String)file.getFile()));
                stream.println("\t\t\t</file>");
                stream.println("\t\t\t<action>");
                stream.println(ClearCaseChangeLogSet.escapeForXml((String)file.getAction()));
                stream.println("\t\t\t</action>");
                stream.println("\t\t\t<version>");
                stream.println(ClearCaseChangeLogSet.escapeForXml((String)file.getVersion()));
                stream.println("\t\t\t</version>");
                stream.println("\t\t\t<operation>");
                stream.println(ClearCaseChangeLogSet.escapeForXml((String)file.getOperation()));
                stream.println("\t\t\t</operation>");
                stream.println("\t\t</element>");
            }
            stream.println("\t</entry>");
        }
        stream.println("</history>");
        stream.close();
    }

    private static String[] getEntryAsStrings(ClearCaseChangeLogEntry entry) {
        String[] array = new String[TAGS.length];
        array[0] = entry.getUser();
        array[1] = entry.getComment();
        array[2] = entry.getDateStr();
        return array;
    }

    private static String escapeForXml(String string) {
        if (string == null) {
            return "";
        }
        int size = string.length();
        char ch = '\u0000';
        StringBuffer escapedString = new StringBuffer(size);
        block7: for (int index = 0; index < size; ++index) {
            ch = string.charAt(index);
            switch (ch) {
                case '&': {
                    escapedString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    escapedString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    escapedString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escapedString.append("&quot;");
                    continue block7;
                }
                default: {
                    escapedString.append(ch);
                }
            }
        }
        return escapedString.toString().trim();
    }
}

