/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import java.io.File;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private boolean useUpdate;
    private String configSpec;
    private boolean useDynamicView;
    private String viewDrive;
    private final String branch;
    private final String vobPaths;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String vobpaths, boolean usedynamicview, String viewdrive, String mkviewoptionalparam) {
        super(viewname, mkviewoptionalparam);
        this.branch = branch;
        this.configSpec = configspec;
        this.useUpdate = useupdate;
        this.vobPaths = vobpaths;
        this.useDynamicView = usedynamicview;
        this.viewDrive = viewdrive;
        if (this.useDynamicView) {
            this.useUpdate = false;
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getVobPaths() {
        return this.vobPaths;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.useDynamicView) {
            if (this.viewDrive != null) {
                env.put("CLEARCASE_VIEWPATH", this.viewDrive + File.separator + this.getViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    protected CheckOutAction createCheckOutAction(ClearToolLauncher launcher) {
        Object action = this.useDynamicView ? new DynamicCheckoutAction(this.createClearTool(launcher), this.getViewName(), this.configSpec) : new SnapshotCheckoutAction(this.createClearTool(launcher), this.getViewName(), this.configSpec, this.useUpdate);
        return action;
    }

    protected PollAction createPollAction(ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(launcher));
    }

    public String[] getBranchNames() {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    private ClearTool createClearTool(ClearToolLauncher launcher) {
        if (this.useDynamicView) {
            return new ClearToolDynamic(launcher, PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.viewDrive);
        }
        return new ClearToolSnapshot(launcher, PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getMkviewOptionalParam());
    }
}

