/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseChangeLogSet;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.util.ChangeLogEntryMerger;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private final String viewName;
    private final String mkviewOptionalParam;

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
    }

    protected abstract CheckOutAction createCheckOutAction(ClearToolLauncher var1);

    protected abstract PollAction createPollAction(ClearToolLauncher var1);

    public abstract String[] getBranchNames();

    public abstract String getVobPaths();

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    public boolean supportsPolling() {
        return true;
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "hudson_view";
        }
        return this.viewName;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.viewName != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.viewName);
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + this.viewName);
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        return this.checkout(build, launcher, workspace, listener, changelogFile, PluginImpl.BASE_DESCRIPTOR.getLogMergeTimeWindow());
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile, int mergeTimeWindow) throws IOException, InterruptedException {
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        CheckOutAction checkOutAction = this.createCheckOutAction(clearToolLauncher);
        PollAction pollAction = this.createPollAction(clearToolLauncher);
        checkOutAction.checkout(launcher, workspace);
        ArrayList<ClearCaseChangeLogEntry> history = new ArrayList<ClearCaseChangeLogEntry>();
        if (build.getPreviousBuild() != null) {
            Date time = ((AbstractBuild)build.getPreviousBuild()).getTimestamp().getTime();
            for (String branchName : this.getBranchNames()) {
                history.addAll(pollAction.getChanges(time, this.viewName, branchName, this.getVobPaths()));
            }
        }
        if (history.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(changelogFile);
        ChangeLogEntryMerger entryMerger = new ChangeLogEntryMerger(mergeTimeWindow * 1000);
        ClearCaseChangeLogSet.saveToChangeLog(fileOutputStream, entryMerger.getMergedList(history));
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        PollAction pollAction = this.createPollAction(this.createClearToolLauncher(listener, workspace, launcher));
        for (String branchName : this.getBranchNames()) {
            List<ClearCaseChangeLogEntry> data = pollAction.getChanges(buildTime, this.viewName, branchName, this.getVobPaths());
            if (data.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

