/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.TaggingAction;
import hudson.plugins.clearcase.util.EventRecordFilter;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private final String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    private transient String normalizedViewName;

    public ChangeLogParser createChangeLogParser() {
        return null;
    }

    public SCMDescriptor<?> getDescriptor() {
        return null;
    }

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
    }

    protected abstract CheckOutAction createCheckOutAction(ClearToolLauncher var1);

    protected abstract PollAction createPollAction(ClearToolLauncher var1);

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    protected abstract ChangeLogAction createChangeLogAction(ClearToolLauncher var1, AbstractBuild<?, ?> var2);

    protected abstract TaggingAction createTaggingAction(ClearToolLauncher var1);

    public abstract String[] getBranchNames();

    public abstract String[] getViewPaths(FilePath var1) throws IOException, InterruptedException;

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.normalizedViewName == null) {
            return super.getModuleRoot(workspace);
        }
        return workspace.child(this.normalizedViewName);
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "hudson_view";
        }
        return this.viewName;
    }

    public String getNormalizedViewName(AbstractProject<?, ?> project) {
        if (this.normalizedViewName == null) {
            this.normalizedViewName = this.viewName;
            Matcher matcher = Pattern.compile("\\$\\{JOB_NAME\\}", 2).matcher(this.normalizedViewName);
            if (matcher.find()) {
                this.normalizedViewName = matcher.replaceAll(project.getName());
            }
            if ((matcher = Pattern.compile("\\$\\{USER_NAME\\}", 2).matcher(this.normalizedViewName)).find()) {
                this.normalizedViewName = matcher.replaceAll(System.getProperty("user.name"));
            }
            this.normalizedViewName = this.normalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        }
        return this.normalizedViewName;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.viewName != null) {
            String normalizedViewName = this.getNormalizedViewName(build.getProject());
            env.put(CLEARCASE_VIEWNAME_ENVSTR, normalizedViewName);
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + normalizedViewName);
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        CheckOutAction checkoutAction = this.createCheckOutAction(clearToolLauncher);
        ChangeLogAction changeLogAction = this.createChangeLogAction(clearToolLauncher, build);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        TaggingAction taggingAction = this.createTaggingAction(clearToolLauncher);
        EventRecordFilter filter = new EventRecordFilter();
        filter.setFilterOutDestroySubBranchEvent(this.isFilteringOutDestroySubBranchEvent());
        checkoutAction.checkout(launcher, workspace, this.getNormalizedViewName(build.getProject()));
        List changelogEntries = null;
        if (build.getPreviousBuild() != null) {
            Date lastBuildTime = build.getPreviousBuild().getTimestamp().getTime();
            changelogEntries = changeLogAction.getChanges(filter, lastBuildTime, this.getNormalizedViewName(build.getProject()), this.getBranchNames(), this.getViewPaths(workspace.child(this.getNormalizedViewName(build.getProject()))));
        }
        if (changelogEntries == null || changelogEntries.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        if (taggingAction != null) {
            // empty if block
        }
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        EventRecordFilter filter = new EventRecordFilter();
        filter.setFilterOutDestroySubBranchEvent(this.isFilteringOutDestroySubBranchEvent());
        PollAction pollAction = this.createPollAction(this.createClearToolLauncher(listener, workspace, launcher));
        return pollAction.getChanges(filter, buildTime, this.getNormalizedViewName(project), this.getBranchNames(), this.getViewPaths(workspace.child(this.getNormalizedViewName(project))));
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(ClearToolLauncher launcher) {
        return new ClearToolSnapshot(launcher, this.mkviewOptionalParam);
    }
}

