/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.TaggingAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.scm.ChangeLogParser;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String loadRules;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent);
        this.stream = this.shortenStreamName(stream);
        this.loadRules = loadrules;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public String getStream() {
        return this.stream;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public String[] getBranchNames() {
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    public String[] getViewPaths(FilePath viewPath) throws IOException, InterruptedException {
        String[] rules = this.loadRules.split("\n");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            while (rule.startsWith("\\") || rule.startsWith("/")) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    protected CheckOutAction createCheckOutAction(ClearToolLauncher launcher) {
        return new UcmSnapshotCheckoutAction(this.createClearTool(launcher), this.getStream(), this.getLoadRules());
    }

    protected PollAction createPollAction(ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(launcher));
    }

    protected ChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build) {
        return new UcmChangeLogAction(this.createClearTool(launcher));
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    protected TaggingAction createTaggingAction(ClearToolLauncher clearToolLauncher) {
        return null;
    }

    private String shortenStreamName(String longStream) {
        if (longStream.startsWith("stream:")) {
            return longStream.substring("stream:".length());
        }
        return longStream;
    }
}

