/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.plugins.clearcase.util.EventRecordFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.regex.Matcher;

public class DefaultPollAction
implements PollAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%En", "%Vn", "%e", "%o"};
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private ClearTool cleartool;

    public DefaultPollAction(ClearTool cleartool) {
        this.cleartool = cleartool;
    }

    public boolean getChanges(EventRecordFilter eventFilter, Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        boolean hasChanges = false;
        for (int i = 0; i < branchNames.length && !hasChanges; ++i) {
            String branchName = branchNames[i];
            Reader lshistoryOutput = this.cleartool.lshistory(this.historyHandler.getFormat(), time, viewName, branchName, viewPaths);
            if (this.parseHistoryOutputForChanges(new BufferedReader(lshistoryOutput), eventFilter)) {
                hasChanges = true;
            }
            lshistoryOutput.close();
        }
        return hasChanges;
    }

    private boolean parseHistoryOutputForChanges(BufferedReader reader, EventRecordFilter eventRecordFilter) throws IOException, InterruptedException {
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("cleartool: Error:")) {
                line = reader.readLine();
                continue;
            }
            Matcher matcher = this.historyHandler.checkLine(line);
            if (matcher != null) {
                String version = matcher.group(3);
                String event = matcher.group(4);
                if (!eventRecordFilter.accept(event, version)) {
                    line = reader.readLine();
                    continue;
                }
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }
}

