/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.plugins.clearcase.ucm.UcmChangeLogSet;
import hudson.scm.ChangeLogParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class UcmChangeLogParser
extends ChangeLogParser {
    public UcmChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(changeLogFile);
        UcmChangeLogSet logSet = this.parse(build, fileInputStream);
        fileInputStream.close();
        return logSet;
    }

    UcmChangeLogSet parse(AbstractBuild build, InputStream changeLogStream) throws IOException, SAXException {
        ArrayList<UcmActivity> history = new ArrayList<UcmActivity>();
        Digester digester = new Digester();
        digester.setClassLoader(UcmChangeLogSet.class.getClassLoader());
        digester.push(history);
        digester.addObjectCreate("*/entry", UcmActivity.class);
        digester.addBeanPropertySetter("*/entry/name");
        digester.addBeanPropertySetter("*/entry/headline");
        digester.addBeanPropertySetter("*/entry/stream");
        digester.addBeanPropertySetter("*/entry/user");
        digester.addObjectCreate("*/subactivity", UcmActivity.class);
        digester.addBeanPropertySetter("*/subactivity/name");
        digester.addBeanPropertySetter("*/subactivity/headline");
        digester.addBeanPropertySetter("*/subactivity/stream");
        digester.addBeanPropertySetter("*/subactivity/user");
        digester.addSetNext("*/subactivity", "addSubActivity");
        digester.addObjectCreate("*/entry/file", UcmActivity.File.class);
        digester.addBeanPropertySetter("*/entry/file/name");
        digester.addBeanPropertySetter("*/entry/file/date", "dateStr");
        digester.addBeanPropertySetter("*/entry/file/comment");
        digester.addBeanPropertySetter("*/entry/file/version");
        digester.addBeanPropertySetter("*/entry/file/event");
        digester.addBeanPropertySetter("*/entry/file/operation");
        digester.addSetNext("*/entry/file", "addFile");
        digester.addSetNext("*/entry", "add");
        digester.parse(changeLogStream);
        return new UcmChangeLogSet(build, history);
    }
}

