/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.plugins.clearcase.util.EventRecordFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmChangeLogAction
implements ChangeLogAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%En", "%Vn", "%[activity]p", "%e", "%o"};
    private static final String[] ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u"};
    private static final String[] INTEGRATION_ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u", "%[contrib_acts]p"};
    private ClearTool cleartool;
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private Map<String, UcmActivity> activityNameToEntry = new HashMap();

    public UcmChangeLogAction(ClearTool cleartool) {
        this.cleartool = cleartool;
    }

    public List<UcmActivity> getChanges(EventRecordFilter eventFilter, Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        BufferedReader reader = new BufferedReader(this.cleartool.lshistory(this.historyHandler.getFormat() + "%c" + "\\n", time, viewName, branchNames[0], viewPaths));
        List history = this.parseHistory(reader, eventFilter, viewName);
        reader.close();
        return history;
    }

    private List<UcmActivity> parseHistory(BufferedReader reader, EventRecordFilter eventRecordFilter, String viewname) throws InterruptedException, IOException {
        ArrayList<UcmActivity> result = new ArrayList<UcmActivity>();
        try {
            StringBuilder commentBuilder = new StringBuilder();
            String line = reader.readLine();
            UcmActivity.File currentFile = null;
            while (line != null) {
                if (line.startsWith("cleartool: Error:")) {
                    line = reader.readLine();
                    continue;
                }
                Matcher matcher = this.historyHandler.checkLine(line);
                if (matcher != null) {
                    if (currentFile != null) {
                        currentFile.setComment(commentBuilder.toString());
                    }
                    commentBuilder = new StringBuilder();
                    currentFile = new UcmActivity.File();
                    currentFile.setDate(this.dateFormatter.parse(matcher.group(1)));
                    currentFile.setName(matcher.group(2));
                    currentFile.setVersion(matcher.group(3));
                    currentFile.setEvent(matcher.group(5));
                    currentFile.setOperation(matcher.group(6));
                    if (!eventRecordFilter.accept(currentFile.getEvent(), currentFile.getVersion())) {
                        line = reader.readLine();
                        continue;
                    }
                    String activityName = matcher.group(4);
                    UcmActivity activity = (UcmActivity)this.activityNameToEntry.get(activityName);
                    if (activity == null) {
                        activity = new UcmActivity();
                        activity.setName(activityName);
                        this.activityNameToEntry.put(activityName, activity);
                        if (activityName.length() != 0) {
                            this.callLsActivity(activity, viewname);
                        } else {
                            activity.setHeadline("Unknown activity");
                            activity.setUser("Unknown");
                            activity.setStream("");
                        }
                        result.add(activity);
                    }
                    activity.addFile(currentFile);
                } else {
                    if (commentBuilder.length() > 0) {
                        commentBuilder.append("\n");
                    }
                    commentBuilder.append(line);
                }
                line = reader.readLine();
            }
            if (currentFile != null) {
                currentFile.setComment(commentBuilder.toString());
            }
        }
        catch (ParseException ex) {
            throw new IOException("Could not parse cleartool output", ex);
        }
        return result;
    }

    private void callLsActivity(UcmActivity activity, String viewname) throws IOException, InterruptedException {
        BufferedReader reader;
        String line;
        ClearToolFormatHandler handler = null;
        handler = activity.isIntegrationActivity() ? new ClearToolFormatHandler(INTEGRATION_ACTIVITY_FORMAT) : new ClearToolFormatHandler(ACTIVITY_FORMAT);
        Matcher matcher = handler.checkLine(line = (reader = new BufferedReader(this.cleartool.lsactivity(activity.getName(), handler.getFormat(), viewname))).readLine());
        if (matcher != null) {
            activity.setHeadline(matcher.group(1));
            activity.setStream(matcher.group(2));
            activity.setUser(matcher.group(3));
            if (activity.isIntegrationActivity()) {
                String contributingActivities = matcher.group(4);
                for (String contributing : contributingActivities.split(" ")) {
                    UcmActivity subActivity = new UcmActivity();
                    activity.addSubActivity(subActivity);
                    subActivity.setName(contributing);
                    this.callLsActivity(subActivity, viewname);
                }
            }
        }
        reader.close();
    }
}

