/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.plugins.clearcase.util.EventRecordFilter;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private final String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    protected transient String normalizedViewName;

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
        this.createAndRegisterListener(viewName);
    }

    protected abstract CheckOutAction createCheckOutAction(ClearToolLauncher var1);

    protected abstract PollAction createPollAction(ClearToolLauncher var1);

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    protected abstract ChangeLogAction createChangeLogAction(ClearToolLauncher var1, AbstractBuild<?, ?> var2, Launcher var3);

    public abstract String[] getBranchNames();

    public abstract String[] getViewPaths(FilePath var1) throws IOException, InterruptedException;

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.normalizedViewName == null) {
            return super.getModuleRoot(workspace);
        }
        return workspace.child(this.normalizedViewName);
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "${USER_NAME}_${JOB_NAME}_${NODE_NAME}_view";
        }
        return this.viewName;
    }

    public String getNormalizedViewName(AbstractBuild<?, ?> build, Launcher launcher) {
        if (this.normalizedViewName == null) {
            this.normalizedViewName = this.viewName;
            if (build != null) {
                this.normalizedViewName = Util.replaceMacro((String)this.viewName, (VariableResolver)new BuildVariableResolver(build, launcher));
            }
            this.normalizedViewName = this.normalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        }
        return this.normalizedViewName;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.normalizedViewName != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.normalizedViewName);
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + this.normalizedViewName);
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        CheckOutAction checkoutAction = this.createCheckOutAction(clearToolLauncher);
        ChangeLogAction changeLogAction = this.createChangeLogAction(clearToolLauncher, build, launcher);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        EventRecordFilter filter = new EventRecordFilter();
        filter.setFilterOutDestroySubBranchEvent(this.isFilteringOutDestroySubBranchEvent());
        checkoutAction.checkout(launcher, workspace, this.getNormalizedViewName(build, launcher));
        List<? extends ChangeLogSet.Entry> changelogEntries = null;
        if (build.getPreviousBuild() != null) {
            Date lastBuildTime = build.getPreviousBuild().getTimestamp().getTime();
            changelogEntries = changeLogAction.getChanges(filter, lastBuildTime, this.getNormalizedViewName(build, launcher), this.getBranchNames(), this.getViewPaths(workspace.child(this.getNormalizedViewName(build, launcher))));
        }
        if (changelogEntries == null || changelogEntries.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        EventRecordFilter filter = new EventRecordFilter();
        filter.setFilterOutDestroySubBranchEvent(this.isFilteringOutDestroySubBranchEvent());
        PollAction pollAction = this.createPollAction(this.createClearToolLauncher(listener, workspace, launcher));
        String normalizedViewName = this.getNormalizedViewName((AbstractBuild)lastBuild, launcher);
        return pollAction.getChanges(filter, buildTime, normalizedViewName, this.getBranchNames(), this.getViewPaths(workspace.child(normalizedViewName)));
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(ClearToolLauncher launcher) {
        return new ClearToolSnapshot(launcher, this.mkviewOptionalParam);
    }

    protected void createAndRegisterListener(final String viewName) {
        Hudson hudson = Hudson.getInstance();
        if (hudson == null) {
            Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.INFO, "Failed to get Hudson instance");
            return;
        }
        hudson.getJobListeners().add((Object)new ItemListener(){

            public void onDeleted(Item item) {
                AbstractProject project;
                if (item instanceof AbstractProject && (project = (AbstractProject)item).getScm() instanceof AbstractClearCaseScm) {
                    StreamTaskListener listener = new StreamTaskListener(System.out);
                    Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)listener);
                    ClearTool ct = AbstractClearCaseScm.this.createClearTool(AbstractClearCaseScm.this.createClearToolLauncher((TaskListener)listener, project.getWorkspace().getParent().getParent(), launcher));
                    try {
                        ct.rmview(viewName);
                    }
                    catch (Exception e) {
                        Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
                    }
                }
            }
        });
    }
}

