/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseChangeLogAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ByteBuffer;
import hudson.util.FormFieldValidator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private boolean useUpdate;
    private String configSpec;
    private boolean useDynamicView;
    private String viewDrive;
    private final String branch;
    private final String vobPaths;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String vobpaths, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent);
        this.branch = branch;
        this.configSpec = configspec;
        this.useUpdate = useupdate;
        this.vobPaths = vobpaths;
        this.useDynamicView = usedynamicview;
        this.viewDrive = viewdrive;
        if (this.useDynamicView) {
            this.useUpdate = false;
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public Object getVobPaths() {
        return this.vobPaths;
    }

    @Override
    public String[] getViewPaths(FilePath viewPath) throws IOException, InterruptedException {
        String[] vobNameArray;
        if (Util.fixEmpty((String)this.vobPaths.trim()) == null) {
            ArrayList<String> vobList = new ArrayList<String>();
            List subFilePaths = viewPath.list((FileFilter)null);
            if (subFilePaths != null && subFilePaths.size() > 0) {
                for (int i = 0; i < subFilePaths.size(); ++i) {
                    if (!((FilePath)subFilePaths.get(i)).isDirectory()) continue;
                    vobList.add(((FilePath)subFilePaths.get(i)).getName());
                }
            }
            vobNameArray = vobList.toArray(new String[0]);
        } else {
            vobNameArray = this.vobPaths.split("(?<!\\\\)[ \\r\\n]+");
            for (int i = 0; i < vobNameArray.length; ++i) {
                vobNameArray[i] = vobNameArray[i].replaceAll("\\\\ ", " ");
            }
        }
        return vobNameArray;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    @Override
    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.useDynamicView) {
            if (this.viewDrive != null) {
                env.put("CLEARCASE_VIEWPATH", this.viewDrive + File.separator + this.normalizedViewName);
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    @Override
    protected CheckOutAction createCheckOutAction(ClearToolLauncher launcher) {
        CheckOutAction action = this.useDynamicView ? new DynamicCheckoutAction(this.createClearTool(launcher), this.configSpec) : new SnapshotCheckoutAction(this.createClearTool(launcher), this.configSpec, this.useUpdate);
        return action;
    }

    @Override
    protected PollAction createPollAction(ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(launcher));
    }

    @Override
    protected BaseChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build, Launcher baseLauncher) {
        return this.createChangeLogAction(launcher, build, this.getDescriptor().getLogMergeTimeWindow(), baseLauncher);
    }

    protected BaseChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build, int logMergeTimeWindow, Launcher baseLauncher) {
        BaseChangeLogAction action = new BaseChangeLogAction(this.createClearTool(launcher), logMergeTimeWindow);
        if (this.useDynamicView) {
            String extendedViewPath = this.viewDrive;
            if (!this.viewDrive.endsWith("\\") || !this.viewDrive.endsWith("/")) {
                extendedViewPath = this.viewDrive.contains("/") ? extendedViewPath + "/" : extendedViewPath + "\\";
            }
            extendedViewPath = extendedViewPath + this.getNormalizedViewName(build, baseLauncher);
            action.setExtendedViewPath(extendedViewPath);
        }
        return action;
    }

    @Override
    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    @Override
    public String[] getBranchNames() {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    @Override
    protected ClearTool createClearTool(ClearToolLauncher launcher) {
        if (this.useDynamicView) {
            return new ClearToolDynamic(launcher, this.viewDrive);
        }
        return super.createClearTool(launcher);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearCaseScmDescriptor
    extends SCMDescriptor<ClearCaseSCM>
    implements ModelObject {
        private String cleartoolExe;
        private int changeLogMergeTimeWindow = 5;

        protected ClearCaseScmDescriptor() {
            super(ClearCaseSCM.class, null);
            this.load();
        }

        public int getLogMergeTimeWindow() {
            return this.changeLogMergeTimeWindow;
        }

        public String getCleartoolExe() {
            if (this.cleartoolExe == null) {
                return "cleartool";
            }
            return this.cleartoolExe;
        }

        public String getDisplayName() {
            return "Base ClearCase";
        }

        public boolean configure(StaplerRequest req) {
            this.cleartoolExe = Util.fixEmpty((String)req.getParameter("clearcase.cleartoolExe").trim());
            String mergeTimeWindow = Util.fixEmpty((String)req.getParameter("clearcase.logmergetimewindow"));
            if (mergeTimeWindow != null) {
                try {
                    this.changeLogMergeTimeWindow = DecimalFormat.getIntegerInstance().parse(mergeTimeWindow).intValue();
                }
                catch (ParseException e) {
                    this.changeLogMergeTimeWindow = 5;
                }
            } else {
                this.changeLogMergeTimeWindow = 5;
            }
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            ClearCaseSCM scm = new ClearCaseSCM(req.getParameter("cc.branch"), req.getParameter("cc.configspec"), req.getParameter("cc.viewname"), req.getParameter("cc.useupdate") != null, req.getParameter("cc.vobpaths"), req.getParameter("cc.usedynamicview") != null, req.getParameter("cc.viewdrive"), req.getParameter("cc.mkviewoptionalparam"), req.getParameter("cc.filterOutDestroySubBranchEvent") != null);
            return scm;
        }

        public void doCleartoolExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp).process();
        }

        public void doConfigSpecCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null || v.length() == 0) {
                        this.error("Config spec is mandatory");
                        return;
                    }
                    if (v.toLowerCase().indexOf("load") < 0) {
                        this.error("Config spec must contain LOAD directive");
                    }
                    this.ok();
                }
            }.process();
        }

        public void doMandatoryCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.error(Util.fixEmpty((String)this.request.getParameter("errorText")));
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteBuffer baos = new ByteBuffer();
            try {
                Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getCleartoolExe(), "-version"}, new String[0], (OutputStream)baos, null);
                proc.join();
                rsp.setContentType("text/plain");
                baos.writeTo((OutputStream)rsp.getOutputStream());
            }
            catch (IOException e) {
                req.setAttribute("error", (Object)e);
                rsp.forward((Object)this, "versionCheckError", req);
            }
        }

        public void doListViews(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getCleartoolExe(), "lsview", "-short"}, new String[0], (OutputStream)baos, null);
            proc.join();
            rsp.setContentType("text/plain");
            rsp.getOutputStream().println("ClearCase Views found:\n");
            baos.writeTo((OutputStream)rsp.getOutputStream());
        }
    }
}

