/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaseline
extends Publisher {
    private static final String ENV_CC_BASELINE_NAME = "CC_BASELINE_NAME";
    private transient String baselineName = null;
    public static final Descriptor<Publisher> DESCRIPTOR = new UcmMakeBaselineDescriptor();
    private final String namePattern;
    private final String commentPattern;
    private final boolean lockStream;
    private final boolean recommend;
    private transient boolean streamSuccessfullyLocked;
    private final boolean fullBaseline;
    private final boolean identical;

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public boolean isLockStream() {
        return this.lockStream;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public boolean isFullBaseline() {
        return this.fullBaseline;
    }

    public boolean isIdentical() {
        return this.identical;
    }

    private UcmMakeBaseline(String namePattern, String commentPattern, boolean lock, boolean recommend, boolean fullBaseline, boolean identical) {
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.lockStream = lock;
        this.recommend = recommend;
        this.fullBaseline = fullBaseline;
        this.identical = identical;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
        FilePath filePath = build.getProject().getWorkspace().child(scm.getViewName());
        Launcher launcher = Executor.currentExecutor().getOwner().getNode().createLauncher((TaskListener)listener);
        HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), (TaskListener)listener, filePath, launcher);
        if (this.lockStream) {
            try {
                this.streamSuccessfullyLocked = this.lockStream(scm.getStream(), clearToolLauncher, filePath);
            }
            catch (Exception ex) {
                listener.getLogger().println("Failed to lock stream: " + ex);
                return false;
            }
        }
        try {
            this.makeBaseline(build, clearToolLauncher, filePath);
            this.baselineName = this.getLatestBaselineName(clearToolLauncher, filePath);
            this.addBuildParameter(build);
        }
        catch (Exception ex) {
            listener.getLogger().println("Failed to create baseline: " + ex);
            return false;
        }
        return true;
    }

    private void addBuildParameter(AbstractBuild<?, ?> build) {
        ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
        parameters.add(new StringParameterValue("PETER", "TESTAR"));
        build.addAction((Action)new ParametersAction(parameters, build));
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getProject().getScm() instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
            FilePath filePath = build.getProject().getWorkspace().child(scm.getViewName());
            HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), (TaskListener)listener, filePath, launcher);
            if (build.getResult().equals(Result.SUCCESS)) {
                this.promoteBaselineToBuiltLevel(scm.getStream(), clearToolLauncher, filePath, this.baselineName);
                if (this.recommend) {
                    this.recommedBaseline(scm.getStream(), clearToolLauncher, filePath);
                }
            }
            if (this.lockStream && this.streamSuccessfullyLocked) {
                this.unlockStream(scm.getStream(), clearToolLauncher, filePath);
            }
        } else {
            listener.getLogger().println("Not a UCM clearcase SCM, cannot create baseline");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private void unlockStream(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unlock");
        cmd.add("stream:");
        cmd.add(stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private boolean lockStream(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lock");
        cmd.add("stream:");
        cmd.add(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, filePath);
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            return false;
        }
        baos.close();
        return true;
    }

    private void makeBaseline(AbstractBuild build, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        String baselineName = Util.replaceMacro((String)this.namePattern, (Map)build.getEnvVars());
        String baselineComment = Util.replaceMacro((String)this.commentPattern, (Map)build.getEnvVars());
        cmd.add("mkbl");
        if (this.identical) {
            cmd.add("-identical");
        }
        cmd.add("-comment");
        cmd.add(baselineComment);
        if (this.fullBaseline) {
            cmd.add("-full");
        } else {
            cmd.add("-incremental");
        }
        cmd.add(baselineName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
    }

    private void recommedBaseline(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-rec");
        cmd.add("-def");
        cmd.add(stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private void promoteBaselineToBuiltLevel(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson promoted baseline to BUILT");
        cmd.add("-level");
        cmd.add("BUILT");
        cmd.add(blName);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private String getLatestBaselineName(HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("%[latest_bls]CXp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "baseline:";
        if (cleartoolResult != null && cleartoolResult.startsWith(prefix)) {
            return cleartoolResult.substring(prefix.length());
        }
        throw new Exception("Failed to get baselinename, reason: " + cleartoolResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UcmMakeBaselineDescriptor
    extends Descriptor<Publisher> {
        public UcmMakeBaselineDescriptor() {
            super(UcmMakeBaseline.class);
        }

        public String getDisplayName() {
            return "ClearCase UCM Makebaseline";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            UcmMakeBaseline p = new UcmMakeBaseline(req.getParameter("mkbl.namepattern"), req.getParameter("mkbl.commentpattern"), req.getParameter("mkbl.lock") != null, req.getParameter("mkbl.recommend") != null, req.getParameter("mkbl.fullBaseline") != null, req.getParameter("mkbl.identical") != null);
            return p;
        }

        public String getHelpFile() {
            return "/plugin/clearcase/ucm/mkbl/help.html";
        }
    }
}

