/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseChangeLogAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private String configSpec;
    private boolean useDynamicView;
    private String viewDrive;
    private final String branch;
    private final String vobPaths;
    private boolean doNotUpdateConfigSpec;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String vobpaths, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, !usedynamicview && useupdate);
        this.branch = branch;
        this.configSpec = configspec;
        this.vobPaths = vobpaths;
        this.useDynamicView = usedynamicview;
        this.viewDrive = viewdrive;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getVobPaths() {
        return this.vobPaths;
    }

    public boolean isDoNotUpdateConfigSpec() {
        return this.doNotUpdateConfigSpec;
    }

    public String[] getViewPaths(FilePath viewPath) throws IOException, InterruptedException {
        String[] vobNameArray;
        if (Util.fixEmpty((String)this.vobPaths.trim()) == null) {
            ArrayList<String> vobList = new ArrayList<String>();
            List subFilePaths = viewPath.list((FileFilter)null);
            if (subFilePaths != null && subFilePaths.size() > 0) {
                for (int i = 0; i < subFilePaths.size(); ++i) {
                    if (!((FilePath)subFilePaths.get(i)).isDirectory()) continue;
                    vobList.add(((FilePath)subFilePaths.get(i)).getName());
                }
            }
            vobNameArray = vobList.toArray(new String[0]);
        } else {
            vobNameArray = this.vobPaths.split("(?<!\\\\)[ \\r\\n]+");
            for (int i = 0; i < vobNameArray.length; ++i) {
                vobNameArray[i] = vobNameArray[i].replaceAll("\\\\ ", " ");
            }
        }
        return vobNameArray;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.useDynamicView) {
            if (this.viewDrive != null) {
                env.put("CLEARCASE_VIEWPATH", this.viewDrive + File.separator + this.getNormalizedViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        Object action = this.useDynamicView ? new DynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.doNotUpdateConfigSpec) : new SnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.isUseUpdate());
        return action;
    }

    protected PollAction createPollAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(variableResolver, launcher));
    }

    protected BaseChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build, Launcher baseLauncher) {
        return this.createChangeLogAction(launcher, build, this.getDescriptor().getLogMergeTimeWindow(), baseLauncher);
    }

    protected BaseChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build, int logMergeTimeWindow, Launcher baseLauncher) {
        BuildVariableResolver variableResolver = new BuildVariableResolver(build, baseLauncher);
        BaseChangeLogAction action = new BaseChangeLogAction(this.createClearTool((VariableResolver)variableResolver, launcher), logMergeTimeWindow);
        if (this.useDynamicView) {
            String extendedViewPath = this.viewDrive;
            if (!this.viewDrive.endsWith("\\") || !this.viewDrive.endsWith("/")) {
                extendedViewPath = this.viewDrive.contains("/") ? extendedViewPath + "/" : extendedViewPath + "\\";
            }
            extendedViewPath = extendedViewPath + this.generateNormalizedViewName(build, baseLauncher);
            action.setExtendedViewPath(extendedViewPath);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    public String[] getBranchNames() {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.useDynamicView) {
            return new ClearToolDynamic(variableResolver, launcher, this.viewDrive);
        }
        return super.createClearTool(variableResolver, launcher);
    }
}

