/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamicUCM;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.util.VariableResolver;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String loadRules;
    private boolean useDynamicView;
    private String viewDrive;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate);
        this.stream = this.shortenStreamName(stream);
        this.loadRules = loadrules;
        this.useDynamicView = usedynamicview;
        this.viewDrive = viewdrive;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public String[] getBranchNames() {
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    public String[] getViewPaths(FilePath viewPath) throws IOException, InterruptedException {
        String[] rules = this.loadRules.split("\n");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            while (!this.useDynamicView && (rule.startsWith("\\") || rule.startsWith("/"))) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        Object action = this.useDynamicView ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.getLoadRules(), this.isUseUpdate());
        return action;
    }

    protected PollAction createPollAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        return new DefaultPollAction(this.createClearTool(variableResolver, launcher));
    }

    protected ChangeLogAction createChangeLogAction(ClearToolLauncher launcher, AbstractBuild<?, ?> build, Launcher baseLauncher) {
        BuildVariableResolver variableResolver = new BuildVariableResolver(build, baseLauncher);
        UcmChangeLogAction action = new UcmChangeLogAction(this.createClearTool((VariableResolver)variableResolver, launcher));
        if (this.useDynamicView) {
            String extendedViewPath = this.viewDrive;
            if (!this.viewDrive.endsWith("\\") || !this.viewDrive.endsWith("/")) {
                extendedViewPath = this.viewDrive.contains("/") ? extendedViewPath + "/" : extendedViewPath + "\\";
            }
            extendedViewPath = extendedViewPath + this.getViewName();
            action.setExtendedViewPath(extendedViewPath);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.useDynamicView) {
            return new ClearToolDynamicUCM(variableResolver, launcher, this.viewDrive);
        }
        return super.createClearTool(variableResolver, launcher);
    }

    private String shortenStreamName(String longStream) {
        if (longStream.startsWith("stream:")) {
            return longStream.substring("stream:".length());
        }
        return longStream;
    }
}

