/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmSnapshotCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String stream;
    private String loadRules;
    private boolean useUpdate;

    public UcmSnapshotCheckoutAction(ClearTool cleartool, String stream, String loadRules, boolean useUpdate) {
        this.cleartool = cleartool;
        this.stream = stream;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean localViewPathExists = new FilePath(workspace, viewName).exists();
        if (this.useUpdate) {
            if (localViewPathExists) {
                String configSpec = this.cleartool.catcs(viewName);
                Set configSpecLoadRules = this.extractLoadRules(configSpec);
                boolean recreate = this.currentConfigSpecUptodate(configSpecLoadRules);
                if (recreate) {
                    this.cleartool.rmview(viewName);
                    this.cleartool.mkview(viewName, this.stream);
                }
            } else {
                this.cleartool.mkview(viewName, this.stream);
            }
            for (String loadRule : this.loadRules.split("\n")) {
                this.cleartool.update(viewName, loadRule.trim());
            }
        } else {
            this.cleartool.rmview(viewName);
            this.cleartool.mkview(viewName, this.stream);
        }
        return true;
    }

    private boolean currentConfigSpecUptodate(Set<String> configSpecLoadRules) {
        boolean recreate = false;
        for (String loadRule : this.loadRules.split("\n")) {
            if (configSpecLoadRules.contains(loadRule)) continue;
            System.out.println("Load rule: " + loadRule + " not found in current config spec, forcing recreation of view");
            recreate = true;
        }
        return recreate;
    }

    private Set<String> extractLoadRules(String configSpec) {
        HashSet<String> rules = new HashSet<String>();
        for (String row : configSpec.split("\n")) {
            String trimmedRow = row.toLowerCase().trim();
            if (!trimmedRow.startsWith("load")) continue;
            String rule = row.trim().substring("load".length()).trim();
            rules.add(rule);
            if (!rule.startsWith("/")) {
                rules.add("/" + rule);
                continue;
            }
            rules.add(rule.substring(1));
        }
        return rules;
    }
}

