/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;

public class ClearToolDynamicUCM
extends ClearToolExec {
    private transient String viewDrive;

    public ClearToolDynamicUCM(VariableResolver variableResolver, ClearToolLauncher launcher, String viewDrive) {
        super(variableResolver, launcher);
        this.viewDrive = viewDrive;
    }

    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return new FilePath(launcher.getWorkspace().getChannel(), this.viewDrive);
    }

    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support setcs with a config spec");
    }

    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.chstream(viewName, stream);
        this.setcs(viewName);
    }

    private void chstream(String viewName, String stream) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-generate");
        cmd.add("stream:" + stream);
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        this.launcher.run(cmd.toCommandArray(), null, null, viewPath);
    }

    private void setcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-tag");
        cmd.add(viewName);
        cmd.add("-stream");
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support mkview");
    }

    public void rmview(String viewName) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support rmview");
    }

    public void update(String viewName, String loadRules) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support update");
    }

    public void startView(String viewTags) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("startview");
        cmd.addTokenized(viewTags);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }
}

