/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClearToolExec
implements ClearTool {
    private transient Pattern viewListPattern;
    protected ClearToolLauncher launcher;
    protected VariableResolver variableResolver;

    public ClearToolExec(VariableResolver variableResolver, ClearToolLauncher launcher) {
        this.variableResolver = variableResolver;
        this.launcher = launcher;
    }

    protected abstract FilePath getRootViewPath(ClearToolLauncher var1);

    @Override
    public Reader lshistory(String format, Date lastBuildDate, String viewName, String branch, String[] viewPaths) throws IOException, InterruptedException {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM.HH:mm:ss");
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lshistory");
        cmd.add("-r");
        cmd.add(new String[]{"-since", formatter.format(lastBuildDate).toLowerCase()});
        cmd.add(new String[]{"-fmt", format});
        if (branch != null && branch.length() > 0) {
            cmd.add(new String[]{"-branch", "brtype:" + branch});
        }
        cmd.add("-nco");
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        for (String path : viewPaths) {
            cmd.add(path);
        }
        InputStreamReader returnReader = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, viewPath)) {
            returnReader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        }
        baos.close();
        return returnReader;
    }

    @Override
    public Reader lsactivity(String activity, String commandFormat, String viewname) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsactivity");
        cmd.add(new String[]{"-fmt", commandFormat});
        cmd.add(activity);
        FilePath workspace = this.launcher.getWorkspace();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, baos, workspace.child(viewname));
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return reader;
    }

    @Override
    public void mklabel(String viewName, String label) throws IOException, InterruptedException {
        throw new AbortException();
    }

    @Override
    public List<String> lsview(boolean onlyActiveDynamicViews) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, null)) {
            return this.parseListOutput(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyActiveDynamicViews);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> lsvob(boolean onlyMOunted) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsvob");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, null)) {
            return this.parseListOutput(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyMOunted);
        }
        return new ArrayList<String>();
    }

    @Override
    public String catcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("catcs");
        cmd.add(new String[]{"-tag", viewName});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String retString = "";
        if (this.launcher.run(cmd.toCommandArray(), null, baos, null)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
            String line = reader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(line);
                line = reader.readLine();
            }
            reader.close();
            retString = builder.toString();
        }
        baos.close();
        return retString;
    }

    private List<String> parseListOutput(Reader consoleReader, boolean onlyStarMarked) throws IOException {
        ArrayList<String> views = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = this.viewListPattern.matcher(line);
            if (matcher.find() && matcher.groupCount() == 3 && (!onlyStarMarked || onlyStarMarked && matcher.group(1).equals("*"))) {
                String vob = matcher.group(2);
                int pos = Math.max(vob.lastIndexOf(92), vob.lastIndexOf(47));
                if (pos != -1) {
                    vob = vob.substring(pos + 1);
                }
                views.add(vob);
            }
            line = reader.readLine();
        }
        reader.close();
        return views;
    }

    private Pattern getListPattern() {
        if (this.viewListPattern == null) {
            this.viewListPattern = Pattern.compile("(.)\\s*(\\S*)\\s*(\\S*)");
        }
        return this.viewListPattern;
    }
}

