/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.util.VariableResolver;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());
    private final AbstractProject<?, ?> project;
    private final Launcher launcher;

    public BuildVariableResolver(AbstractBuild<?, ?> build, Launcher launcher) {
        this.project = build.getProject();
        this.launcher = launcher;
    }

    public String resolve(String key) {
        System.err.println("now resolving " + key);
        try {
            if ("JOB_NAME".equals(key)) {
                return this.project.getName();
            }
            if ("COMPUTERNAME".equals(key)) {
                return Util.fixEmpty((String)this.launcher.getComputer().getName()) == null ? "master" : this.launcher.getComputer().getName();
            }
            if ("NODE_NAME".equals(key)) {
                return Util.fixEmpty((String)this.launcher.getComputer().getName()) == null ? "master" : this.launcher.getComputer().getName();
            }
            if ("USER_NAME".equals(key)) {
                return (String)this.launcher.getComputer().getSystemProperties().get("user.name");
            }
            if (this.launcher.getComputer().getEnvVars().containsKey(key)) {
                return (String)this.launcher.getComputer().getEnvVars().get(key);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Variable name '" + key + "' look up failed because of " + e);
        }
        return null;
    }
}

