/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.history.DefaultFilter;
import hudson.plugins.clearcase.history.DestroySubBranchFilter;
import hudson.plugins.clearcase.history.FieldFilter;
import hudson.plugins.clearcase.history.FileFilter;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.SCM;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private final String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    private transient String normalizedViewName;
    private final boolean useUpdate;
    private final boolean removeViewOnRename;
    private String excludedRegions;

    protected void setNormalizedViewName(String normalizedViewName) {
        this.normalizedViewName = normalizedViewName;
    }

    protected String getNormalizedViewName() {
        return this.normalizedViewName;
    }

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean removeViewOnRename, String excludedRegions) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
        this.useUpdate = useUpdate;
        this.removeViewOnRename = removeViewOnRename;
        this.excludedRegions = excludedRegions;
        this.createAndRegisterListener();
    }

    protected abstract CheckOutAction createCheckOutAction(VariableResolver var1, ClearToolLauncher var2);

    protected abstract HistoryAction createHistoryAction(VariableResolver var1, ClearToolLauncher var2);

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    public abstract String[] getBranchNames();

    public abstract String[] getViewPaths(FilePath var1) throws IOException, InterruptedException;

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getNormalizedViewName() == null) {
            return super.getModuleRoot(workspace);
        }
        return workspace.child(this.getNormalizedViewName());
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "${USER_NAME}_${JOB_NAME}_${NODE_NAME}_view";
        }
        return this.viewName;
    }

    public String generateNormalizedViewName(AbstractBuild<?, ?> build, Launcher launcher) {
        String generatedNormalizedViewName = this.viewName;
        generatedNormalizedViewName = Util.replaceMacro((String)this.viewName, (VariableResolver)new BuildVariableResolver(build, launcher));
        this.normalizedViewName = generatedNormalizedViewName = generatedNormalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        return generatedNormalizedViewName;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.getNormalizedViewName() != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.getNormalizedViewName());
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + this.getNormalizedViewName());
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build, launcher);
        CheckOutAction checkoutAction = this.createCheckOutAction((VariableResolver)variableResolver, clearToolLauncher);
        HistoryAction historyAction = this.createHistoryAction((VariableResolver)variableResolver, clearToolLauncher);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        String normalizedViewName = this.generateNormalizedViewName(build, launcher);
        checkoutAction.checkout(launcher, workspace, normalizedViewName);
        List changelogEntries = null;
        if (build.getPreviousBuild() != null) {
            Date lastBuildTime = build.getPreviousBuild().getTimestamp().getTime();
            changelogEntries = historyAction.getChanges(lastBuildTime, normalizedViewName, this.getBranchNames(), this.getViewPaths(workspace.child(normalizedViewName)));
        }
        if (changelogEntries == null || changelogEntries.isEmpty()) {
            return this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        BuildVariableResolver variableResolver = new BuildVariableResolver((AbstractBuild)lastBuild, launcher);
        HistoryAction historyAction = this.createHistoryAction((VariableResolver)variableResolver, this.createClearToolLauncher(listener, workspace, launcher));
        String normalizedViewName = this.generateNormalizedViewName((AbstractBuild)lastBuild, launcher);
        return historyAction.hasChanges(buildTime, normalizedViewName, this.getBranchNames(), this.getViewPaths(workspace.child(normalizedViewName)));
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        return new ClearToolSnapshot(variableResolver, launcher, this.mkviewOptionalParam);
    }

    protected void createAndRegisterListener() {
        Hudson hudson = Hudson.getInstance();
        if (hudson == null) {
            Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.INFO, "Failed to get Hudson instance");
            return;
        }
        hudson.getJobListeners().add((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions.length() == 0 ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    protected List<Filter> configureFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)new DefaultFilter());
        String[] excludedStrings = this.getExcludedRegionsNormalized();
        if (excludedStrings != null && excludedStrings.length > 0) {
            for (String s : excludedStrings) {
                filters.add((Filter)new FileFilter(FieldFilter.Type.DoesNotContainRegxp, s));
            }
        }
        if (this.isFilteringOutDestroySubBranchEvent()) {
            filters.add((Filter)new DestroySubBranchFilter());
        }
        return filters;
    }

    static /* synthetic */ boolean access$000(AbstractClearCaseScm x0) {
        return x0.removeViewOnRename;
    }
}

