/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.history;

import hudson.plugins.clearcase.history.Filter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FieldFilter
implements Filter {
    private Type type;
    private String patternText;
    private Pattern pattern;

    public FieldFilter(Type type, String patternText) {
        this.type = type;
        switch (this.type) {
            case Equals: 
            case NotEquals: 
            case Contains: 
            case DoesNotContain: {
                this.patternText = patternText;
                this.pattern = null;
                break;
            }
            case EqualsIgnoreCase: 
            case NotEqualsIgnoreCase: 
            case ContainsIgnoreCase: 
            case DoesNotContainIgnoreCase: {
                this.patternText = patternText.toLowerCase();
                this.pattern = null;
                break;
            }
            case ContainsRegxp: 
            case DoesNotContainRegxp: {
                this.patternText = patternText;
                this.pattern = Pattern.compile(patternText);
            }
        }
    }

    public boolean accept(String value) {
        switch (this.type) {
            case Equals: {
                return value.equals(this.patternText);
            }
            case EqualsIgnoreCase: {
                return value.toLowerCase().equals(this.patternText);
            }
            case NotEquals: {
                return !value.equals(this.patternText);
            }
            case NotEqualsIgnoreCase: {
                return !value.toLowerCase().equals(this.patternText);
            }
            case Contains: {
                return value.contains(this.patternText);
            }
            case ContainsIgnoreCase: {
                return value.toLowerCase().contains(this.patternText);
            }
            case DoesNotContain: {
                return !value.contains(this.patternText);
            }
            case DoesNotContainIgnoreCase: {
                System.out.println(value.toLowerCase() + " <>" + this.patternText);
                return !value.toLowerCase().contains(this.patternText);
            }
            case ContainsRegxp: {
                Matcher m = this.pattern.matcher(value);
                return m.find();
            }
            case DoesNotContainRegxp: {
                Matcher m2 = this.pattern.matcher(value);
                return !m2.find();
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Equals,
        EqualsIgnoreCase,
        NotEquals,
        NotEqualsIgnoreCase,
        Contains,
        ContainsIgnoreCase,
        DoesNotContain,
        DoesNotContainIgnoreCase,
        ContainsRegxp,
        DoesNotContainRegxp;

    }
}

