/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.history;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHistoryAction
implements HistoryAction {
    protected ClearTool cleartool;
    protected List<Filter> filters;
    protected String extendedViewPath;

    public AbstractHistoryAction(ClearTool cleartool, List<Filter> filters) {
        this.cleartool = cleartool;
        this.filters = filters != null ? filters : new ArrayList();
    }

    public boolean hasChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List entries = this.runLsHistory(time, viewName, branchNames, viewPaths);
        List filtered = this.filterEntries(entries);
        return filtered.size() > 0;
    }

    public List<? extends ChangeLogSet.Entry> getChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List entries = this.runLsHistory(time, viewName, branchNames, viewPaths);
        List filtered = this.filterEntries(entries);
        List changelog = this.buildChangelog(viewName, filtered);
        return changelog;
    }

    protected List<HistoryEntry> runLsHistory(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        ClearToolFormatHandler historyHandler = this.getHistoryFormatHandler();
        ArrayList<HistoryEntry> fullList = new ArrayList<HistoryEntry>();
        try {
            for (String branchName : branchNames) {
                BufferedReader reader = new BufferedReader(this.cleartool.lshistory(historyHandler.getFormat() + "%c" + "\\n", time, viewName, branchName, viewPaths));
                fullList.addAll(this.parseLsHistory(reader));
                reader.close();
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return fullList;
    }

    protected List<HistoryEntry> parseLsHistory(BufferedReader reader) throws IOException, InterruptedException, ParseException {
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        HistoryEntry currentEntry = null;
        StringBuilder commentBuilder = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("cleartool: Error:")) {
                line = reader.readLine();
                continue;
            }
            Matcher matcher = this.getHistoryFormatHandler().checkLine(line);
            if (matcher != null) {
                if (currentEntry != null) {
                    currentEntry.setComment(commentBuilder.toString());
                }
                commentBuilder = new StringBuilder();
                currentEntry = this.parseEventLine(matcher, line);
                String fileName = currentEntry.getElement();
                if (this.extendedViewPath != null && fileName.toLowerCase().startsWith(this.extendedViewPath)) {
                    fileName = fileName.substring(this.extendedViewPath.length());
                    currentEntry.setElement(fileName);
                }
                entries.add(currentEntry);
            } else {
                if (commentBuilder.length() > 0) {
                    commentBuilder.append("\n");
                }
                commentBuilder.append(line);
            }
            line = reader.readLine();
        }
        if (currentEntry != null) {
            currentEntry.setComment(commentBuilder.toString());
        }
        return entries;
    }

    protected List<HistoryEntry> filterEntries(List<HistoryEntry> unfiltered) throws IOException, InterruptedException {
        ArrayList<HistoryEntry> filtered = new ArrayList<HistoryEntry>();
        for (HistoryEntry entry : unfiltered) {
            boolean accepted = true;
            for (Filter filter : this.filters) {
                accepted &= filter.accept(entry);
            }
            if (!accepted) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    protected abstract List<? extends ChangeLogSet.Entry> buildChangelog(String var1, List<HistoryEntry> var2) throws IOException, InterruptedException;

    protected abstract ClearToolFormatHandler getHistoryFormatHandler();

    protected abstract HistoryEntry parseEventLine(Matcher var1, String var2) throws IOException, InterruptedException, ParseException;

    public void setExtendedViewPath(String path) {
        this.extendedViewPath = path != null ? path.toLowerCase() : null;
    }

    public String getExtendedViewPath() {
        return this.extendedViewPath;
    }
}

