/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;

public class DynamicCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String configSpec;

    public DynamicCheckoutAction(ClearTool cleartool, String configSpec) {
        this.cleartool = cleartool;
        this.configSpec = configSpec;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        this.cleartool.startView(viewName);
        String currentConfigSpec = this.cleartool.catcs(viewName).trim();
        if (!this.configSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
            String tempConfigSpec = this.configSpec;
            if (launcher.isUnix()) {
                tempConfigSpec = this.configSpec.replaceAll("\r\n", "\n");
            }
            this.cleartool.setcs(viewName, tempConfigSpec);
        }
        return true;
    }
}

