/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.model.User;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.scm.ChangeLogSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmActivity
extends ChangeLogSet.Entry {
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    private String name;
    private String headline;
    private String stream;
    private String user;
    private List<File> files = new ArrayList();
    private List<UcmActivity> subActivities = new ArrayList();

    public UcmActivity() {
    }

    public UcmActivity(UcmActivity other) {
        UcmActivity child;
        this.name = other.name;
        this.headline = other.headline;
        this.stream = other.stream;
        this.user = other.user;
        this.setParent(other.getParent());
        for (UcmActivity subAct : other.getSubActivities()) {
            child = new UcmActivity(subAct);
            this.addSubActivity(child);
        }
        for (File otherFile : other.files) {
            child = new File(otherFile);
            this.files.add(child);
        }
    }

    @Exported
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Exported
    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Exported
    public boolean isIntegrationActivity() {
        return this.name.startsWith("deliver.") || this.name.startsWith("rebase.");
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public void addFiles(Collection<File> files) {
        this.files.addAll(files);
    }

    @Exported
    public List<File> getFiles() {
        return this.files;
    }

    @Exported
    public boolean hasFiles() {
        return this.files.size() > 0;
    }

    public void addSubActivity(UcmActivity activity) {
        this.subActivities.add(activity);
    }

    public void addSubActivities(Collection<UcmActivity> activities) {
        this.subActivities.addAll(activities);
    }

    @Exported
    public List<UcmActivity> getSubActivities() {
        return this.subActivities;
    }

    @Exported
    public boolean hasSubActivities() {
        return this.subActivities.size() > 0;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public String getMsg() {
        return this.headline;
    }

    public User getAuthor() {
        return User.get((String)this.user);
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.files.size());
        for (File file : this.files) {
            paths.add(file.getName());
        }
        return paths;
    }

    public String toString() {
        return this.name + ": " + this.headline;
    }

    static /* synthetic */ DateFormat access$000() {
        return DATE_FORMATTER;
    }
}

