/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.ucm.UcmMakeBaseline;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaseline
extends Publisher {
    private static final String ENV_CC_BASELINE_NAME = "CC_BASELINE_NAME";
    private transient List<String> readWriteComponents = null;
    private transient List<String> latestBaselines = null;
    private transient List<String> createdBaselines = null;
    public static final Descriptor<Publisher> DESCRIPTOR = new UcmMakeBaselineDescriptor();
    private final String namePattern;
    private final String commentPattern;
    private final boolean lockStream;
    private final boolean recommend;
    private transient boolean streamSuccessfullyLocked;
    private final boolean fullBaseline;
    private final boolean identical;
    private final String dynamicViewName;
    private final boolean rebaseDynamicView;

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public boolean isLockStream() {
        return this.lockStream;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public boolean isFullBaseline() {
        return this.fullBaseline;
    }

    public boolean isIdentical() {
        return this.identical;
    }

    public String getDynamicViewName() {
        return this.dynamicViewName;
    }

    public boolean isRebaseDynamicView() {
        return this.rebaseDynamicView;
    }

    public List<String> getReadWriteComponents() {
        return this.readWriteComponents;
    }

    private UcmMakeBaseline(String namePattern, String commentPattern, boolean lock, boolean recommend, boolean fullBaseline, boolean identical, boolean rebaseDynamicView, String dynamicViewName) {
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.lockStream = lock;
        this.recommend = recommend;
        this.fullBaseline = fullBaseline;
        this.identical = identical;
        this.rebaseDynamicView = rebaseDynamicView;
        this.dynamicViewName = dynamicViewName;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
        Launcher launcher = Executor.currentExecutor().getOwner().getNode().createLauncher((TaskListener)listener);
        HudsonClearToolLauncher clearToolLauncher = this.getHudsonClearToolLauncher(build, listener, launcher);
        FilePath filePath = build.getProject().getWorkspace().child(scm.generateNormalizedViewName(build, launcher));
        if (this.lockStream) {
            try {
                this.streamSuccessfullyLocked = this.lockStream(scm.getStream(), clearToolLauncher, filePath);
            }
            catch (Exception ex) {
                listener.getLogger().println("Failed to lock stream: " + ex);
                return false;
            }
        }
        try {
            this.readWriteComponents = this.getReadWriteComponent(clearToolLauncher, filePath);
            if (this.readWriteComponents.size() != 0) {
                this.makeBaseline(build, clearToolLauncher, filePath);
                this.latestBaselines = this.getLatestBaselineNames(clearToolLauncher, filePath);
            }
        }
        catch (Exception ex) {
            listener.getLogger().println("Failed to create baseline: " + ex);
            return false;
        }
        return true;
    }

    private HudsonClearToolLauncher getHudsonClearToolLauncher(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) {
        FilePath workspaceRoot = build.getProject().getWorkspace();
        HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), (TaskListener)listener, workspaceRoot, launcher);
        return clearToolLauncher;
    }

    private void addBuildParameter(AbstractBuild<?, ?> build) {
        if (this.latestBaselines != null && !this.latestBaselines.isEmpty()) {
            ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
            String baselineName = (String)this.latestBaselines.get(0);
            parameters.add(new StringParameterValue(ENV_CC_BASELINE_NAME, baselineName));
            build.addAction((Action)new ParametersAction(parameters, build));
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getProject().getScm() instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
            FilePath filePath = build.getProject().getWorkspace().child(scm.generateNormalizedViewName(build, launcher));
            HudsonClearToolLauncher clearToolLauncher = this.getHudsonClearToolLauncher(build, listener, launcher);
            if (build.getResult().equals(Result.SUCCESS)) {
                for (String baselineName : this.latestBaselines) {
                    this.promoteBaselineToBuiltLevel(scm.getStream(), clearToolLauncher, filePath, baselineName);
                }
                if (this.recommend) {
                    this.recommedBaseline(scm.getStream(), clearToolLauncher, filePath);
                }
                if (this.rebaseDynamicView) {
                    for (String baseline : this.latestBaselines) {
                        this.rebaseDynamicView(clearToolLauncher, filePath, this.dynamicViewName, baseline);
                    }
                }
            } else if (build.getResult().equals(Result.FAILURE)) {
                ArrayList<String> alreadyRejected = new ArrayList<String>();
                for (String baselineName : this.createdBaselines) {
                    String realBaselineName = null;
                    for (String fullBaselineName : this.latestBaselines) {
                        if (!fullBaselineName.startsWith(baselineName) || alreadyRejected.contains(fullBaselineName)) continue;
                        realBaselineName = fullBaselineName;
                    }
                    if (realBaselineName == null) {
                        listener.getLogger().println("Couldn't find baseline name for " + baselineName);
                        continue;
                    }
                    this.demoteBaselineToRejectedLevel(scm.getStream(), clearToolLauncher, filePath, realBaselineName);
                    alreadyRejected.add(realBaselineName);
                }
            }
            if (this.lockStream && this.streamSuccessfullyLocked) {
                this.unlockStream(scm.getStream(), clearToolLauncher, filePath);
            }
        } else {
            listener.getLogger().println("Not a UCM clearcase SCM, cannot create baseline");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private void rebaseDynamicView(HudsonClearToolLauncher clearToolLauncher, FilePath filePath, String dynamicView, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rebase");
        cmd.add("-baseline");
        cmd.add(blName);
        cmd.add("-view");
        cmd.add(dynamicView);
        cmd.add("-complete");
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private void unlockStream(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unlock");
        cmd.add("stream:" + stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private boolean lockStream(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lock");
        cmd.add("stream:" + stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            return false;
        }
        baos.close();
        return true;
    }

    private void makeBaseline(AbstractBuild build, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        String baselineName = Util.replaceMacro((String)this.namePattern, (Map)build.getEnvVars());
        String baselineComment = Util.replaceMacro((String)this.commentPattern, (Map)build.getEnvVars());
        cmd.add("mkbl");
        if (this.identical) {
            cmd.add("-identical");
        }
        cmd.add("-comment");
        cmd.add(baselineComment);
        if (this.fullBaseline) {
            cmd.add("-full");
        } else {
            cmd.add("-incremental");
        }
        cmd.add("-comp");
        StringBuffer lstComp = new StringBuffer();
        for (String comp : this.readWriteComponents) {
            lstComp.append(",");
            lstComp.append(comp);
        }
        lstComp.delete(0, 1);
        cmd.add(lstComp.toString());
        cmd.add(baselineName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
        this.createdBaselines = new ArrayList();
        Pattern pattern = Pattern.compile("Created baseline \".+?\"");
        Matcher matcher = pattern.matcher(cleartoolResult);
        while (matcher.find()) {
            String match = matcher.group();
            String newBaseline = match.substring(match.indexOf("\"") + 1, match.length() - 1);
            this.createdBaselines.add(newBaseline);
        }
    }

    private void recommedBaseline(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-rec");
        cmd.add("-def");
        cmd.add(stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private void promoteBaselineToBuiltLevel(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson promoted baseline to BUILT");
        cmd.add("-level");
        cmd.add("BUILT");
        cmd.add(blName);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private void demoteBaselineToRejectedLevel(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson demoted baseline to REJECTED");
        cmd.add("-level");
        cmd.add("REJECTED");
        cmd.add(blName);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private List<String> getReadWriteComponent(HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("%[mod_comps]Xp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "component:";
        if (cleartoolResult != null && cleartoolResult.startsWith("component:")) {
            String[] componentNamesSplit;
            ArrayList<String> componentNames = new ArrayList<String>();
            for (String componentName : componentNamesSplit = cleartoolResult.split(" ")) {
                String componentNameTrimmed = componentName.substring(componentName.indexOf("component:") + "component:".length()).trim();
                if (componentNameTrimmed.equals("")) continue;
                componentNames.add(componentNameTrimmed);
            }
            return componentNames;
        }
        throw new Exception("Failed to get read/write component, reason: " + cleartoolResult);
    }

    private String getComponentforBaseline(HudsonClearToolLauncher clearToolLauncher, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[component]Xp");
        cmd.add(blName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "component:";
        return cleartoolResult.substring(cleartoolResult.indexOf(cleartoolResult) + prefix.length());
    }

    private List<String> getLatestBaselineNames(HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("%[latest_bls]Xp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "baseline:";
        if (cleartoolResult != null && cleartoolResult.startsWith(prefix)) {
            String[] baselineNamesSplit;
            ArrayList<String> baselineNames = new ArrayList<String>();
            for (String baselineName : baselineNamesSplit = cleartoolResult.split("baseline:")) {
                String blComp;
                String baselineNameTrimmed = baselineName.trim();
                if (baselineNameTrimmed.equals("") || !this.readWriteComponents.contains(blComp = this.getComponentforBaseline(clearToolLauncher, filePath, baselineNameTrimmed))) continue;
                baselineNames.add(baselineNameTrimmed);
            }
            return baselineNames;
        }
        throw new Exception("Failed to get baselinename, reason: " + cleartoolResult);
    }
}

