/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.base;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.history.AbstractHistoryAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ChangeLogEntryMerger;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHistoryAction
extends AbstractHistoryAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%u", "%En", "%Vn", "%e", "%o"};
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private int maxTimeDifferenceMillis;

    public BaseHistoryAction(ClearTool cleartool, List<Filter> filters, int maxTimeDifferenceMillis) {
        super(cleartool, filters);
        this.maxTimeDifferenceMillis = maxTimeDifferenceMillis;
    }

    protected List<? extends ChangeLogSet.Entry> buildChangelog(String viewName, List<HistoryEntry> entries) {
        ArrayList<ClearCaseChangeLogEntry> fullList = new ArrayList<ClearCaseChangeLogEntry>();
        for (HistoryEntry entry : entries) {
            ClearCaseChangeLogEntry changelogEntry = new ClearCaseChangeLogEntry();
            changelogEntry.setDate(entry.getDate());
            changelogEntry.setUser(entry.getUser());
            changelogEntry.setComment(entry.getComment());
            ClearCaseChangeLogEntry.FileElement fileElement = new ClearCaseChangeLogEntry.FileElement(entry.getElement(), entry.getVersionId(), entry.getEvent(), entry.getOperation());
            changelogEntry.addElement(fileElement);
            fullList.add(changelogEntry);
        }
        ChangeLogEntryMerger entryMerger = new ChangeLogEntryMerger(this.maxTimeDifferenceMillis);
        return entryMerger.getMergedList(fullList);
    }

    protected ClearToolFormatHandler getHistoryFormatHandler() {
        return this.historyHandler;
    }

    protected HistoryEntry parseEventLine(Matcher matcher, String line) throws ParseException {
        HistoryEntry entry = new HistoryEntry();
        entry.setLine(line);
        entry.setDateText(matcher.group(1));
        entry.setUser(matcher.group(2).trim());
        entry.setElement(matcher.group(3).trim());
        entry.setVersionId(matcher.group(4).trim());
        entry.setEvent(matcher.group(5).trim());
        entry.setOperation(matcher.group(6).trim());
        return entry;
    }
}

