/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.DefaultPollAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmPollAction
extends DefaultPollAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%En", "%Vn", "%[activity]p", "%e", "%o"};
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);

    public UcmPollAction(ClearTool cleartool, List<Filter> filters) {
        super(cleartool, filters);
    }

    protected ClearToolFormatHandler getHistoryFormatHandler() {
        return this.historyHandler;
    }

    protected HistoryEntry parseLine(String line) throws ParseException {
        if (line.startsWith("cleartool: Error:")) {
            return null;
        }
        Matcher matcher = this.historyHandler.checkLine(line);
        if (matcher == null) {
            return null;
        }
        HistoryEntry entry = new HistoryEntry();
        entry.setLine(line);
        entry.setDateText(matcher.group(1));
        entry.setElement(matcher.group(2));
        entry.setVersionId(matcher.group(3));
        entry.setActivityName(matcher.group(4));
        entry.setEvent(matcher.group(5));
        entry.setOperation(matcher.group(6));
        return entry;
    }
}

