/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamicUCM;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String loadRules;
    private boolean useDynamicView;
    private String viewDrive;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, excludedRegions);
        this.stream = this.shortenStreamName(stream);
        this.loadRules = loadrules;
        this.useDynamicView = usedynamicview;
        this.viewDrive = viewdrive;
    }

    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename) {
        this(stream, loadrules, viewname, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, "");
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public String[] getBranchNames() {
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    public String[] getViewPaths(FilePath viewPath) throws IOException, InterruptedException {
        String[] rules = this.loadRules.split("[\\r\\n]+");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            while (!this.useDynamicView && (rule.startsWith("\\") || rule.startsWith("/"))) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.useDynamicView) {
            return new FilePath(workspace.getChannel(), this.viewDrive + File.separator + this.getNormalizedViewName());
        }
        return super.getModuleRoot(workspace);
    }

    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        CheckOutAction action = this.useDynamicView ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.getLoadRules(), this.isUseUpdate());
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        UcmHistoryAction action = new UcmHistoryAction(this.createClearTool(variableResolver, launcher), this.configureFilters());
        if (this.useDynamicView) {
            String extendedViewPath = this.viewDrive;
            if (!this.viewDrive.endsWith("\\") || !this.viewDrive.endsWith("/")) {
                extendedViewPath = this.viewDrive.contains("/") ? extendedViewPath + "/" : extendedViewPath + "\\";
            }
            extendedViewPath = extendedViewPath + this.getViewName();
            action.setExtendedViewPath(extendedViewPath);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.useDynamicView) {
            return new ClearToolDynamicUCM(variableResolver, launcher, this.viewDrive);
        }
        return super.createClearTool(variableResolver, launcher);
    }

    private String shortenStreamName(String longStream) {
        if (longStream.startsWith("stream:")) {
            return longStream.substring("stream:".length());
        }
        return longStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearCaseUcmScmDescriptor
    extends SCMDescriptor<ClearCaseUcmSCM>
    implements ModelObject {
        protected ClearCaseUcmScmDescriptor() {
            super(ClearCaseUcmSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "UCM ClearCase";
        }

        public boolean configure(StaplerRequest req) {
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            ClearCaseUcmSCM scm = new ClearCaseUcmSCM(req.getParameter("ucm.stream"), req.getParameter("ucm.loadrules"), req.getParameter("ucm.viewname"), req.getParameter("ucm.usedynamicview") != null, req.getParameter("ucm.viewdrive"), req.getParameter("ucm.mkviewoptionalparam"), req.getParameter("ucm.filterOutDestroySubBranchEvent") != null, req.getParameter("ucm.useupdate") != null, req.getParameter("ucm.rmviewonrename") != null, req.getParameter("ucm.excludedRegions"));
            return scm;
        }
    }
}

