/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.PollAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultPollAction
implements PollAction {
    private ClearTool cleartool;
    protected List<Filter> filters;

    public DefaultPollAction(ClearTool cleartool, List<Filter> filters) {
        this.cleartool = cleartool;
        this.filters = filters;
    }

    @Override
    public boolean getChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        boolean hasChanges = false;
        ClearToolFormatHandler historyHandler = this.getHistoryFormatHandler();
        for (int i = 0; i < branchNames.length && !hasChanges; ++i) {
            String branchName = branchNames[i];
            Reader lshistoryOutput = this.cleartool.lshistory(historyHandler.getFormat(), time, viewName, branchName, viewPaths);
            if (this.parseHistoryOutputForChanges(new BufferedReader(lshistoryOutput))) {
                hasChanges = true;
            }
            lshistoryOutput.close();
        }
        return hasChanges;
    }

    protected abstract ClearToolFormatHandler getHistoryFormatHandler();

    protected abstract HistoryEntry parseLine(String var1) throws ParseException;

    protected boolean parseHistoryOutputForChanges(BufferedReader reader) throws IOException, InterruptedException {
        String line = reader.readLine();
        while (line != null) {
            try {
                boolean accepted;
                HistoryEntry entry = this.parseLine(line);
                if (entry != null && (accepted = this.filterEntry(entry))) {
                    return true;
                }
            }
            catch (ParseException e) {
                this.cleartool.getLauncher().getListener().getLogger().append("ClearCase Plugin: This line could not be parsed: " + line);
            }
            line = reader.readLine();
        }
        return false;
    }

    protected boolean filterEntry(HistoryEntry entry) {
        boolean included = true;
        if (this.filters == null) {
            return true;
        }
        for (Filter filter : this.filters) {
            included &= filter.accept(entry);
        }
        return included;
    }
}

