/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;

public class SnapshotCheckoutAction
implements CheckOutAction {
    private final String configSpec;
    private final boolean useUpdate;
    private final ClearTool cleartool;

    public SnapshotCheckoutAction(ClearTool clearTool, String configSpec, boolean useUpdate) {
        this.cleartool = clearTool;
        this.configSpec = configSpec;
        this.useUpdate = useUpdate;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean updateView = this.useUpdate;
        boolean localViewPathExists = new FilePath(workspace, viewName).exists();
        String tempConfigSpec = PathUtil.convertPathsBetweenUnixAndWindows(this.configSpec, launcher);
        if (localViewPathExists) {
            if (updateView) {
                String currentConfigSpec = this.cleartool.catcs(viewName).trim();
                if (!tempConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                    updateView = false;
                }
            } else {
                this.cleartool.rmview(viewName);
                localViewPathExists = false;
            }
        }
        if (!localViewPathExists) {
            this.cleartool.mkview(viewName, null);
            updateView = false;
        }
        if (updateView) {
            this.cleartool.update(viewName, null);
        } else {
            this.cleartool.setcs(viewName, tempConfigSpec);
        }
        return true;
    }
}

