/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogEntryMerger {
    private Map<String, List<MergedLogEntry>> userEntries = new HashMap<String, List<MergedLogEntry>>();
    private transient int maxTimeDifference;

    public ChangeLogEntryMerger() {
        this(0);
    }

    public ChangeLogEntryMerger(int maxTimeDifferenceMillis) {
        this.maxTimeDifference = maxTimeDifferenceMillis + 1000;
    }

    public List<ClearCaseChangeLogEntry> getMergedList(List<ClearCaseChangeLogEntry> orgList) {
        this.userEntries.clear();
        for (ClearCaseChangeLogEntry entry : orgList) {
            boolean wasMerged = false;
            List<MergedLogEntry> entries = this.getUserEntries(entry.getUser());
            for (MergedLogEntry storedEntry : entries) {
                if (!this.canBeMerged(storedEntry, entry)) continue;
                storedEntry.merge(entry);
                wasMerged = true;
                break;
            }
            if (wasMerged) continue;
            entries.add(new MergedLogEntry(entry));
        }
        List<ClearCaseChangeLogEntry> list = this.getList();
        Collections.sort(list, new Comparator<ClearCaseChangeLogEntry>(){

            @Override
            public int compare(ClearCaseChangeLogEntry o1, ClearCaseChangeLogEntry o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        return list;
    }

    private List<ClearCaseChangeLogEntry> getList() {
        ArrayList<ClearCaseChangeLogEntry> list = new ArrayList<ClearCaseChangeLogEntry>();
        Set<String> users = this.userEntries.keySet();
        for (String user : users) {
            List<MergedLogEntry> userList = this.userEntries.get(user);
            for (MergedLogEntry entry : userList) {
                entry.entry.setDate(entry.oldest);
                list.add(entry.entry);
            }
        }
        return list;
    }

    private List<MergedLogEntry> getUserEntries(String user) {
        if (!this.userEntries.containsKey(user)) {
            this.userEntries.put(user, new ArrayList());
        }
        return this.userEntries.get(user);
    }

    private boolean canBeMerged(MergedLogEntry entryOne, ClearCaseChangeLogEntry entryTwo) {
        if (entryOne.entry.getComment().equals(entryTwo.getComment())) {
            long oldestDiff = Math.abs(entryOne.oldest.getTime() - entryTwo.getDate().getTime());
            long newestDiff = Math.abs(entryOne.newest.getTime() - entryTwo.getDate().getTime());
            return oldestDiff < (long)this.maxTimeDifference || newestDiff < (long)this.maxTimeDifference;
        }
        return false;
    }

    private class MergedLogEntry {
        private ClearCaseChangeLogEntry entry;
        private Date oldest;
        private Date newest;

        public MergedLogEntry(ClearCaseChangeLogEntry entry) {
            this.entry = entry;
            this.oldest = entry.getDate();
            this.newest = entry.getDate();
        }

        public void merge(ClearCaseChangeLogEntry newEntry) {
            Date date = newEntry.getDate();
            if (date.after(this.newest)) {
                this.newest = date;
            } else if (date.before(this.oldest)) {
                this.oldest = date;
            }
            this.entry.addElements(newEntry.getElements());
        }
    }
}

