/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.ucm.UcmMakeBaselineComposite;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaselineComposite
extends Publisher {
    public static final Descriptor<Publisher> DESCRIPTOR = new UcmMakeBaselineDescriptor();
    private final String compositeNamePattern;
    private final String compositeStreamSelector;
    private final String compositeComponentName;
    private final boolean extractInfoFile;
    private final String fileName;

    public String getCompositeNamePattern() {
        return this.compositeNamePattern;
    }

    public String getCompositeStreamSelector() {
        return this.compositeStreamSelector;
    }

    public String getCompositeComponentName() {
        return this.compositeComponentName;
    }

    public boolean isExtractInfoFile() {
        return this.extractInfoFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    private UcmMakeBaselineComposite(String compositeNamePattern, String compositeStreamSelector, String compositeComponentName, boolean extractInfoFile, String fileName) {
        this.compositeNamePattern = compositeNamePattern.trim();
        this.compositeStreamSelector = compositeStreamSelector.trim();
        this.compositeComponentName = compositeComponentName.trim();
        this.extractInfoFile = extractInfoFile;
        this.fileName = fileName.trim();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!(build.getProject().getScm() instanceof ClearCaseUcmSCM)) return true;
        ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
        FilePath filePath = build.getProject().getWorkspace().child(scm.getViewName());
        HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), (TaskListener)listener, filePath, launcher);
        if (build.getResult().equals(Result.SUCCESS)) {
            try {
                String compositeBaselineName = Util.replaceMacro((String)this.compositeNamePattern, (Map)build.getEnvVars());
                String pvob = this.compositeStreamSelector;
                if (this.compositeStreamSelector.contains("@" + File.separator)) {
                    pvob = this.compositeStreamSelector.substring(this.compositeStreamSelector.indexOf("@" + File.separator) + 2, this.compositeStreamSelector.length());
                }
                this.makeCompositeBaseline(compositeBaselineName, this.compositeStreamSelector, this.compositeComponentName, pvob, clearToolLauncher, filePath);
                this.promoteCompositeBaselineToBuiltLevel(compositeBaselineName, pvob, clearToolLauncher, filePath);
                if (!this.extractInfoFile) return true;
                this.processExtractInfoFile(this.compositeComponentName, pvob, compositeBaselineName, this.fileName, clearToolLauncher, filePath);
                return true;
            }
            catch (Exception ex) {
                listener.getLogger().println("Failed to create baseline: " + ex);
                return false;
            }
        } else {
            listener.getLogger().println("Not a UCM clearcase SCM, cannot create baseline composite");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private List<String> getComponentList(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        String[] comp;
        ArrayList<String> result = new ArrayList<String>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[components]XCp\"");
        cmd.add(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        String cleartoolResult = baos.toString();
        baos.close();
        for (String c : comp = cleartoolResult.split(",\\s")) {
            result.add(c.split("component:")[1]);
        }
        return result;
    }

    private String getOneViewFromStream(String stream, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[views]p\"");
        cmd.add(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        String cleartoolResult = baos.toString();
        baos.close();
        String[] resultLines = cleartoolResult.split("\n");
        if (resultLines.length == 0) {
            throw new Exception("There is no view attached to the stream '" + stream + "'");
        }
        String viewsLines = resultLines[resultLines.length - 1];
        return viewsLines.split(" ")[0];
    }

    private void makeCompositeBaseline(String compositeBaselineName, String compositeStream, String compositeComponent, String pvob, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        String compositeView = this.getOneViewFromStream(this.compositeStreamSelector, clearToolLauncher, filePath);
        List componentList = this.getComponentList(this.compositeStreamSelector, clearToolLauncher, filePath);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkbl");
        cmd.add("-nc");
        cmd.add("-view");
        cmd.add(compositeView);
        cmd.add("-comp");
        cmd.add(compositeComponent + "@" + File.separator + pvob);
        cmd.add("-full");
        cmd.add("-ddepends_on");
        StringBuffer sb = new StringBuffer();
        for (String comp : componentList) {
            if (comp.contains(compositeComponent)) continue;
            sb.append(",").append(comp);
        }
        sb.delete(0, 1);
        cmd.add(sb.toString());
        cmd.add("-adepends_on");
        cmd.add(sb.toString());
        cmd.add(compositeBaselineName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
    }

    private void promoteCompositeBaselineToBuiltLevel(String compositeBaselineName, String pvob, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-level");
        cmd.add("BUILT");
        cmd.add(compositeBaselineName + "@" + File.separator + pvob);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    private String getComponent(String baseline, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("\"%[component]p\"");
        cmd.add(baseline);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
        return cleartoolResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExtractInfoFile(String compositeComponnentName, String pvob, String compositeBaselineName, String fileName, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("\"%[depends_on]p\"");
        cmd.add(compositeBaselineName + "@" + File.separator + pvob);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
        String[] baselinesComp = cleartoolResult.split(" ");
        List<String> baselineList = Arrays.asList(baselinesComp);
        Collections.sort(baselineList);
        OutputStreamWriter fw = null;
        try {
            File f = new File(filePath.getRemote() + File.separator + fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            fw = new FileWriter(f);
            fw.write("The composite baseline is '" + compositeBaselineName + "'");
            for (String baseLine : baselineList) {
                fw.write("\nThe  baseline of component '" + this.getComponent(baseLine, clearToolLauncher, filePath) + "' is :" + baseLine);
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

