/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;

public class DynamicCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String configSpec;
    private boolean doNotUpdateConfigSpec;

    public DynamicCheckoutAction(ClearTool cleartool, String configSpec, boolean doNotUpdateConfigSpec) {
        this.cleartool = cleartool;
        this.configSpec = configSpec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        this.cleartool.startView(viewName);
        String currentConfigSpec = this.cleartool.catcs(viewName).trim();
        String tempConfigSpec = PathUtil.convertPathForOS(this.configSpec, launcher);
        if (!this.doNotUpdateConfigSpec && !tempConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
            this.cleartool.setcs(viewName, tempConfigSpec);
        }
        return true;
    }
}

