/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;

public class SnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final String configSpec;
    private final boolean useUpdate;
    private final ClearTool cleartool;
    private final String[] loadRules;

    public SnapshotCheckoutAction(ClearTool clearTool, String configSpec, String[] loadRules, boolean useUpdate) {
        this.cleartool = clearTool;
        this.configSpec = configSpec;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean updateView = this.useUpdate;
        boolean localViewPathExists = new FilePath(workspace, viewName).exists();
        String jobConfigSpec = PathUtil.convertPathForOS(this.configSpec, launcher);
        if (localViewPathExists) {
            if (updateView) {
                String currentConfigSpec = this.getLoadRuleFreeConfigSpec(this.cleartool.catcs(viewName).trim());
                if (!jobConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                    updateView = false;
                }
            } else {
                this.cleartool.rmview(viewName);
                localViewPathExists = false;
            }
        }
        if (!localViewPathExists) {
            this.cleartool.mkview(viewName, null);
            updateView = false;
        }
        if (updateView) {
            this.cleartool.update(viewName, null);
        } else {
            String newConfigSpec = jobConfigSpec + "\n";
            for (String loadRule : this.loadRules) {
                if (!loadRule.startsWith("\\") && !loadRule.startsWith("/")) {
                    loadRule = PathUtil.fileSepForOS(launcher.isUnix()) + loadRule;
                }
                newConfigSpec = newConfigSpec + "load " + loadRule.trim() + "\n";
            }
            newConfigSpec = PathUtil.convertPathForOS(newConfigSpec, launcher);
            this.cleartool.setcs(viewName, PathUtil.convertPathForOS(newConfigSpec, launcher));
        }
        return true;
    }
}

