/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaseline
extends Publisher {
    private static final String ENV_CC_BASELINE_NAME = "CC_BASELINE_NAME";
    private transient List<String> readWriteComponents = null;
    private transient List<String> latestBaselines = new ArrayList<String>();
    private transient List<String> createdBaselines = null;
    public static final Descriptor<Publisher> DESCRIPTOR = new UcmMakeBaselineDescriptor();
    private final String namePattern;
    private final String commentPattern;
    private final boolean lockStream;
    private final boolean recommend;
    private transient boolean streamSuccessfullyLocked;
    private final boolean fullBaseline;
    private final boolean identical;
    private final String dynamicViewName;
    private final boolean rebaseDynamicView;

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public boolean isLockStream() {
        return this.lockStream;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public boolean isFullBaseline() {
        return this.fullBaseline;
    }

    public boolean isIdentical() {
        return this.identical;
    }

    public String getDynamicViewName() {
        return this.dynamicViewName;
    }

    public boolean isRebaseDynamicView() {
        return this.rebaseDynamicView;
    }

    public List<String> getReadWriteComponents() {
        return this.readWriteComponents;
    }

    private UcmMakeBaseline(String namePattern, String commentPattern, boolean lock, boolean recommend, boolean fullBaseline, boolean identical, boolean rebaseDynamicView, String dynamicViewName) {
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.lockStream = lock;
        this.recommend = recommend;
        this.fullBaseline = fullBaseline;
        this.identical = identical;
        this.rebaseDynamicView = rebaseDynamicView;
        this.dynamicViewName = dynamicViewName;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
        Launcher launcher = Executor.currentExecutor().getOwner().getNode().createLauncher((TaskListener)listener);
        HudsonClearToolLauncher clearToolLauncher = this.getHudsonClearToolLauncher(build, listener, launcher);
        FilePath filePath = build.getProject().getWorkspace().child(scm.generateNormalizedViewName(build, launcher));
        if (this.lockStream) {
            try {
                this.streamSuccessfullyLocked = this.lockStream(scm.getStream(), clearToolLauncher, scm, filePath);
            }
            catch (Exception ex) {
                listener.getLogger().println("Failed to lock stream: " + ex);
                return false;
            }
        }
        try {
            this.readWriteComponents = this.getReadWriteComponent(clearToolLauncher, scm, filePath);
            if (this.readWriteComponents.size() != 0) {
                this.createdBaselines = this.makeBaseline(build, clearToolLauncher, scm, filePath);
                this.latestBaselines = this.getLatestBaselineNames(clearToolLauncher, scm, filePath);
                this.addBuildParameter(build);
            }
        }
        catch (Exception ex) {
            listener.getLogger().println("Failed to create baseline: " + ex);
            return false;
        }
        return true;
    }

    private HudsonClearToolLauncher getHudsonClearToolLauncher(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) {
        FilePath workspaceRoot = build.getProject().getWorkspace();
        HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), (TaskListener)listener, workspaceRoot, launcher);
        return clearToolLauncher;
    }

    private void addBuildParameter(AbstractBuild<?, ?> build) {
        if (this.latestBaselines != null && !this.latestBaselines.isEmpty()) {
            ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
            String baselineName = this.latestBaselines.get(0);
            parameters.add(new StringParameterValue(ENV_CC_BASELINE_NAME, baselineName));
            build.addAction((Action)new ParametersAction(parameters));
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getProject().getScm() instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM scm = (ClearCaseUcmSCM)build.getProject().getScm();
            FilePath filePath = build.getProject().getWorkspace().child(scm.generateNormalizedViewName(build, launcher));
            HudsonClearToolLauncher clearToolLauncher = this.getHudsonClearToolLauncher(build, listener, launcher);
            if (build.getResult().equals(Result.SUCCESS)) {
                for (String baselineName : this.latestBaselines) {
                    this.promoteBaselineToBuiltLevel(scm.getStream(), clearToolLauncher, scm, filePath, baselineName);
                }
                if (this.recommend) {
                    this.recommedBaseline(scm.getStream(), clearToolLauncher, scm, filePath);
                }
                if (this.rebaseDynamicView) {
                    for (String baseline : this.latestBaselines) {
                        this.rebaseDynamicView(clearToolLauncher, scm, filePath, this.dynamicViewName, baseline);
                    }
                }
            } else if (build.getResult().equals(Result.FAILURE)) {
                ArrayList<String> alreadyRejected = new ArrayList<String>();
                for (String baselineName : this.createdBaselines) {
                    String realBaselineName = null;
                    for (String fullBaselineName : this.latestBaselines) {
                        if (!fullBaselineName.startsWith(baselineName) || alreadyRejected.contains(fullBaselineName)) continue;
                        realBaselineName = fullBaselineName;
                    }
                    if (realBaselineName == null) {
                        listener.getLogger().println("Couldn't find baseline name for " + baselineName);
                        continue;
                    }
                    this.demoteBaselineToRejectedLevel(scm.getStream(), clearToolLauncher, scm, filePath, realBaselineName);
                    alreadyRejected.add(realBaselineName);
                }
            }
            if (this.lockStream && this.streamSuccessfullyLocked) {
                this.unlockStream(scm.getStream(), clearToolLauncher, scm, filePath);
            }
        } else {
            listener.getLogger().println("Not a UCM clearcase SCM, cannot create baseline");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private void rebaseDynamicView(HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath, String dynamicView, String blName) throws InterruptedException, IOException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rebase");
        cmd.add("-baseline");
        cmd.add(blName);
        cmd.add("-view");
        cmd.add(dynamicView);
        cmd.add("-complete");
        clearToolLauncher.run(cmd.toCommandArray(), null, null, clearToolLauncherPath);
    }

    private void unlockStream(String stream, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws IOException, InterruptedException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unlock");
        cmd.add("stream:" + stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, clearToolLauncherPath);
    }

    private boolean lockStream(String stream, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws IOException, InterruptedException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lock");
        cmd.add("stream:" + stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, clearToolLauncherPath);
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            return false;
        }
        baos.close();
        return true;
    }

    private List<String> makeBaseline(AbstractBuild build, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws Exception {
        ArrayList<String> createdBaselinesList = new ArrayList<String>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        String baselineName = Util.replaceMacro((String)this.namePattern, (Map)build.getEnvVars());
        String baselineComment = Util.replaceMacro((String)this.commentPattern, (Map)build.getEnvVars());
        cmd.add("mkbl");
        if (this.identical) {
            cmd.add("-identical");
        }
        cmd.add("-comment");
        cmd.add(baselineComment);
        if (this.fullBaseline) {
            cmd.add("-full");
        } else {
            cmd.add("-incremental");
        }
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            cmd.add("-view");
            cmd.add(scm.getViewName());
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        cmd.add("-comp");
        StringBuffer lstComp = new StringBuffer();
        for (String comp : this.readWriteComponents) {
            lstComp.append(",");
            lstComp.append(comp);
        }
        lstComp.delete(0, 1);
        cmd.add(lstComp.toString());
        cmd.add(baselineName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + cleartoolResult);
        }
        Pattern pattern = Pattern.compile("Created baseline \".+?\"");
        Matcher matcher = pattern.matcher(cleartoolResult);
        while (matcher.find()) {
            String match = matcher.group();
            String newBaseline = match.substring(match.indexOf("\"") + 1, match.length() - 1);
            createdBaselinesList.add(newBaseline);
        }
        return createdBaselinesList;
    }

    private void recommedBaseline(String stream, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws InterruptedException, IOException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-rec");
        cmd.add("-def");
        cmd.add(stream);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, clearToolLauncherPath);
    }

    private void promoteBaselineToBuiltLevel(String stream, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath, String blName) throws InterruptedException, IOException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson promoted baseline to BUILT");
        cmd.add("-level");
        cmd.add("BUILT");
        cmd.add(blName);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, clearToolLauncherPath);
    }

    private void demoteBaselineToRejectedLevel(String stream, HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath, String blName) throws InterruptedException, IOException {
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson demoted baseline to REJECTED");
        cmd.add("-level");
        cmd.add("REJECTED");
        cmd.add(blName);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, clearToolLauncherPath);
    }

    private List<String> getReadWriteComponent(HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = filePath;
        cmd.add("lsproject");
        if (scm.isUseDynamicView()) {
            cmd.add("-view");
            cmd.add(scm.getViewName());
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        } else {
            cmd.add("-cview");
        }
        cmd.add("-fmt");
        cmd.add("%[mod_comps]Xp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "component:";
        if (cleartoolResult != null && cleartoolResult.startsWith("component:")) {
            String[] componentNamesSplit;
            ArrayList<String> componentNames = new ArrayList<String>();
            for (String componentName : componentNamesSplit = cleartoolResult.split(" ")) {
                String componentNameTrimmed = componentName.substring(componentName.indexOf("component:") + "component:".length()).trim();
                if (componentNameTrimmed.equals("")) continue;
                componentNames.add(componentNameTrimmed);
            }
            return componentNames;
        }
        throw new Exception("Failed to get read/write component, reason: " + cleartoolResult);
    }

    private String getComponentforBaseline(HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = filePath;
        if (scm.isUseDynamicView()) {
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[component]Xp");
        cmd.add(blName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "component:";
        return cleartoolResult.substring(cleartoolResult.indexOf(cleartoolResult) + prefix.length());
    }

    private List<String> getLatestBaselineNames(HudsonClearToolLauncher clearToolLauncher, ClearCaseUcmSCM scm, FilePath filePath) throws Exception {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = filePath;
        cmd.add("lsstream");
        if (scm.isUseDynamicView()) {
            cmd.add("-view");
            cmd.add(scm.getViewName());
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        cmd.add("-fmt");
        cmd.add("%[latest_bls]Xp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "baseline:";
        if (cleartoolResult != null && cleartoolResult.startsWith(prefix)) {
            String[] baselineNamesSplit;
            ArrayList<String> baselineNames = new ArrayList<String>();
            for (String baselineName : baselineNamesSplit = cleartoolResult.split("baseline:")) {
                String blComp;
                String baselineNameTrimmed = baselineName.trim();
                if (baselineNameTrimmed.equals("") || !this.readWriteComponents.contains(blComp = this.getComponentforBaseline(clearToolLauncher, scm, filePath, baselineNameTrimmed))) continue;
                baselineNames.add(baselineNameTrimmed);
            }
            return baselineNames;
        }
        throw new Exception("Failed to get baselinename, reason: " + cleartoolResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UcmMakeBaselineDescriptor
    extends Descriptor<Publisher> {
        public UcmMakeBaselineDescriptor() {
            super(UcmMakeBaseline.class);
        }

        public String getDisplayName() {
            return "ClearCase UCM Makebaseline";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            UcmMakeBaseline p = new UcmMakeBaseline(req.getParameter("mkbl.namepattern"), req.getParameter("mkbl.commentpattern"), req.getParameter("mkbl.lock") != null, req.getParameter("mkbl.recommend") != null, req.getParameter("mkbl.fullBaseline") != null, req.getParameter("mkbl.identical") != null, req.getParameter("mkbl.rebaseDynamicView") != null, req.getParameter("mkbl.dynamicViewName"));
            return p;
        }

        public String getHelpFile() {
            return "/plugin/clearcase/ucm/mkbl/help.html";
        }
    }
}

