/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseHistoryAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.scm.ChangeLogParser;
import hudson.util.VariableResolver;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private String configSpec;
    private final String branch;
    private boolean doNotUpdateConfigSpec;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename, String excludedRegions) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, !usedynamicview && useupdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadRules);
        this.branch = branch;
        this.configSpec = configspec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
    }

    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename) {
        this(branch, configspec, viewname, useupdate, loadRules, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, doNotUpdateConfigSpec, rmviewonrename, "");
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isDoNotUpdateConfigSpec() {
        return this.doNotUpdateConfigSpec;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.isUseDynamicView()) {
            if (this.getViewDrive() != null) {
                env.put("CLEARCASE_VIEWPATH", this.getViewDrive() + File.separator + this.getNormalizedViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        Object action = this.isUseDynamicView() ? new DynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.doNotUpdateConfigSpec) : new SnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.getLoadRules(), this.isUseUpdate());
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        BaseHistoryAction action = new BaseHistoryAction(ct, this.configureFilters(launcher), this.getDescriptor().getLogMergeTimeWindow());
        try {
            String pwv = ct.pwv(this.getViewName());
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    public String[] getBranchNames() {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive());
        }
        return super.createClearTool(variableResolver, launcher);
    }
}

