/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.util.VariableResolver;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());
    private final Launcher launcher;
    private AbstractBuild<?, ?> build;

    public BuildVariableResolver(AbstractBuild<?, ?> build, Launcher launcher) {
        this.build = build;
        this.launcher = launcher;
    }

    public String resolve(String key) {
        try {
            if ("JOB_NAME".equals(key) && this.build != null && this.build.getProject() != null) {
                return this.build.getProject().getName();
            }
            if ("NODE_NAME".equals(key)) {
                return Util.fixEmpty((String)(StringUtils.isEmpty((String)this.launcher.getComputer().getName()) ? "master" : this.launcher.getComputer().getName()));
            }
            if ("USER_NAME".equals(key)) {
                return (String)this.launcher.getComputer().getSystemProperties().get("user.name");
            }
            if (this.build.getEnvVars().containsKey(key)) {
                return (String)this.build.getEnvVars().get(key);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Variable name '" + key + "' look up failed because of " + e);
        }
        return null;
    }
}

