/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseHistoryAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ByteBuffer;
import hudson.util.FormFieldValidator;
import hudson.util.VariableResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private String configSpec;
    private final String branch;
    private boolean doNotUpdateConfigSpec;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename, String excludedRegions) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, !usedynamicview && useupdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadRules);
        this.branch = branch;
        this.configSpec = configspec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
    }

    public ClearCaseSCM(String branch, String configspec, String viewname, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename) {
        this(branch, configspec, viewname, useupdate, loadRules, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, doNotUpdateConfigSpec, rmviewonrename, "");
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isDoNotUpdateConfigSpec() {
        return this.doNotUpdateConfigSpec;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    @Override
    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.isUseDynamicView()) {
            if (this.getViewDrive() != null) {
                env.put("CLEARCASE_VIEWPATH", this.getViewDrive() + File.separator + this.getNormalizedViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    @Override
    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        CheckOutAction action = this.isUseDynamicView() ? new DynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.doNotUpdateConfigSpec) : new SnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.configSpec, this.getLoadRules(), this.isUseUpdate());
        return action;
    }

    @Override
    protected HistoryAction createHistoryAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        BaseHistoryAction action = new BaseHistoryAction(ct, this.configureFilters(launcher), this.getDescriptor().getLogMergeTimeWindow());
        try {
            String pwv = ct.pwv(this.getViewName());
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    @Override
    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    @Override
    public String[] getBranchNames() {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = branchArray[i].replaceAll("\\\\ ", " ");
        }
        return branchArray;
    }

    @Override
    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearCaseScmDescriptor
    extends SCMDescriptor<ClearCaseSCM>
    implements ModelObject {
        private String cleartoolExe;
        private int changeLogMergeTimeWindow = 5;

        protected ClearCaseScmDescriptor() {
            super(ClearCaseSCM.class, null);
            this.load();
        }

        public int getLogMergeTimeWindow() {
            return this.changeLogMergeTimeWindow;
        }

        public String getCleartoolExe() {
            if (this.cleartoolExe == null) {
                return "cleartool";
            }
            return this.cleartoolExe;
        }

        public String getDisplayName() {
            return "Base ClearCase";
        }

        public boolean configure(StaplerRequest req) {
            this.cleartoolExe = Util.fixEmpty((String)req.getParameter("clearcase.cleartoolExe").trim());
            String mergeTimeWindow = Util.fixEmpty((String)req.getParameter("clearcase.logmergetimewindow"));
            if (mergeTimeWindow != null) {
                try {
                    this.changeLogMergeTimeWindow = DecimalFormat.getIntegerInstance().parse(mergeTimeWindow).intValue();
                }
                catch (ParseException e) {
                    this.changeLogMergeTimeWindow = 5;
                }
            } else {
                this.changeLogMergeTimeWindow = 5;
            }
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            ClearCaseSCM scm = new ClearCaseSCM(req.getParameter("cc.branch"), req.getParameter("cc.configspec"), req.getParameter("cc.viewname"), req.getParameter("cc.useupdate") != null, req.getParameter("cc.loadrules"), req.getParameter("cc.usedynamicview") != null, req.getParameter("cc.viewdrive"), req.getParameter("cc.mkviewoptionalparam"), req.getParameter("cc.filterOutDestroySubBranchEvent") != null, req.getParameter("cc.doNotUpdateConfigSpec") != null, req.getParameter("cc.rmviewonrename") != null, req.getParameter("cc.excludedRegions"));
            return scm;
        }

        public void doCleartoolExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp).process();
        }

        public void doExcludedRegionsCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmptyAndTrim((String)this.request.getParameter("value"));
                    if (v != null) {
                        String[] regions;
                        for (String region : regions = v.split("[\\r\\n]+")) {
                            try {
                                Pattern.compile(region);
                            }
                            catch (PatternSyntaxException e) {
                                this.error("Invalid regular expression. " + e.getMessage());
                            }
                        }
                    }
                    this.ok();
                }
            }.process();
        }

        public void doConfigSpecCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null || v.length() == 0) {
                        this.error("Config spec is mandatory");
                        return;
                    }
                    for (String cSpecLine : v.split("[\\r\\n]+")) {
                        if (!cSpecLine.startsWith("load ")) continue;
                        this.error("Config spec can not contain load rules");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doMandatoryCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.error(Util.fixEmpty((String)this.request.getParameter("errorText")));
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteBuffer baos = new ByteBuffer();
            try {
                Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getCleartoolExe(), "-version"}, new String[0], (OutputStream)baos, null);
                proc.join();
                rsp.setContentType("text/plain");
                baos.writeTo((OutputStream)rsp.getOutputStream());
            }
            catch (IOException e) {
                req.setAttribute("error", (Object)e);
                rsp.forward((Object)this, "versionCheckError", req);
            }
        }

        public void doListViews(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getCleartoolExe(), "lsview", "-short"}, new String[0], (OutputStream)baos, null);
            proc.join();
            rsp.setContentType("text/plain");
            rsp.getOutputStream().println("ClearCase Views found:\n");
            baos.writeTo((OutputStream)rsp.getOutputStream());
        }
    }
}

