/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.User;
import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.scm.ChangeLogSet;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseChangeLogEntry
extends ChangeLogSet.Entry {
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private String user = "";
    private String dateStr = "";
    private Date date = null;
    private String comment = "";
    private List<FileElement> files = new ArrayList();

    public ClearCaseChangeLogEntry() {
    }

    public ClearCaseChangeLogEntry(Date date, String user, String action, String comment, String file, String version) {
        this(date, user, comment);
        this.files.add(new FileElement(file, version, action, ""));
    }

    public ClearCaseChangeLogEntry(Date date, String user, String comment) {
        this.date = (Date)date.clone();
        this.user = user;
        this.comment = comment;
    }

    public void addElement(FileElement element) {
        this.files.add(element);
    }

    public void addElements(Collection<FileElement> files) {
        this.files.addAll(files);
    }

    @Exported
    public List<FileElement> getElements() {
        return this.files;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Exported
    public String getDateStr() {
        if (this.date == null) {
            return this.dateStr;
        }
        return DATE_FORMATTER.format(this.date);
    }

    public void setDateStr(String date) {
        try {
            this.date = DATE_FORMATTER.parse(date);
        }
        catch (ParseException e) {
            this.dateStr = date;
        }
    }

    @Exported
    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public void setFile(String file) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement(file, "", "", ""));
        } else {
            ((FileElement)this.files.get(0)).setFile(file);
        }
    }

    @Deprecated
    public void setVersion(String version) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement("", version, "", ""));
        } else {
            ((FileElement)this.files.get(0)).setVersion(version);
        }
    }

    @Deprecated
    public void setAction(String action) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement("", "", action, ""));
        } else {
            ((FileElement)this.files.get(0)).setAction(action);
        }
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.user);
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.files.size());
        for (FileElement file : this.files) {
            paths.add(file.getFile());
        }
        return paths;
    }

    @Exported
    public String getMsg() {
        return this.comment;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }
}

