/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Random;

public class ClearToolDynamic
extends ClearToolExec {
    private transient String viewDrive;
    private String optionalMkviewParameters;

    public ClearToolDynamic(VariableResolver variableResolver, ClearToolLauncher launcher, String viewDrive, String optionalMkviewParameters) {
        super(variableResolver, launcher);
        this.viewDrive = viewDrive;
        this.optionalMkviewParameters = optionalMkviewParameters;
    }

    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return new FilePath(launcher.getWorkspace().getChannel(), this.viewDrive);
    }

    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        if (configSpec == null) {
            configSpec = "";
        }
        FilePath configSpecFile = this.launcher.getWorkspace().createTextTempFile("configspec", ".txt", configSpec);
        String csLocation = "";
        if (!configSpec.equals("")) {
            csLocation = configSpecFile.getRemote();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-tag");
        cmd.add(viewName);
        if (!csLocation.equals("")) {
            cmd.add(csLocation);
        } else {
            cmd.add("-current");
        }
        this.launcher.run(cmd.toCommandArray(), null, null, this.getRootViewPath(this.launcher).child(viewName));
        configSpecFile.delete();
    }

    public void mkview(String viewName, String streamSelector, String defaultStorageDir) throws IOException, InterruptedException {
        boolean isOptionalParamContainsHost = false;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewName);
        if (this.optionalMkviewParameters != null && this.optionalMkviewParameters.length() > 0) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
            isOptionalParamContainsHost = this.optionalMkviewParameters.contains("-host");
        }
        if (!isOptionalParamContainsHost && defaultStorageDir != null && defaultStorageDir.length() > 0) {
            Integer rndNum = new Random().nextInt();
            String seperator = PathUtil.fileSepForOS((boolean)this.getLauncher().getLauncher().isUnix());
            String viewStorageDir = defaultStorageDir + seperator + viewName + "." + rndNum.toString();
            cmd.add(viewStorageDir);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic view does not support mkview (String, String)");
    }

    public void rmview(String viewName) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic view does not support rmview");
    }

    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmtag");
        cmd.add("-view");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + builder.toString());
        }
    }

    public void update(String viewName, String loadRules) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic view does not support update");
    }

    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic view does not support syncronize");
    }

    public void startView(String viewTags) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("startview");
        cmd.addTokenized(viewTags);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }
}

